/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onlab.packet.MacAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class LispMacAddress
extends LispAfiAddress {
    protected final MacAddress address;

    public LispMacAddress(MacAddress address) {
        super(AddressFamilyIdentifierEnum.MAC);
        this.address = address;
    }

    public MacAddress getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispMacAddress) {
            LispMacAddress other = (LispMacAddress)obj;
            return Objects.equals(this.address, other.address) && Objects.equals((Object)this.getAfi(), (Object)other.getAfi());
        }
        return false;
    }

    public String toString() {
        return this.address.toString();
    }

    public static class MacAddressWriter
    implements LispAddressWriter<LispMacAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispMacAddress address) throws LispWriterException {
            byte[] macByte = address.getAddress().toBytes();
            byteBuf.writeBytes(macByte);
        }
    }

    public static class MacAddressReader
    implements LispAddressReader<LispMacAddress> {
        private static final int SIZE_OF_MAC_ADDRESS = 6;

        @Override
        public LispMacAddress readFrom(ByteBuf byteBuf) throws LispParseError {
            byte[] macByte = new byte[6];
            byteBuf.readBytes(macByte);
            MacAddress macAddress = MacAddress.valueOf((byte[])macByte);
            return new LispMacAddress(macAddress);
        }
    }
}

