/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.onlab.packet.Data;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IP;
import org.onlab.packet.IPacket;
import org.onlab.packet.UDP;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.AbstractLispMessage;
import org.onosproject.lisp.msg.protocols.LispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageReaderFactory;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;

public final class DefaultLispEncapsulatedControl
extends AbstractLispMessage
implements LispEncapsulatedControl {
    private final boolean isSecurity;
    private final IP innerIpHeader;
    private final UDP innerUdp;
    private final LispMessage innerMessage;
    static final EcmWriter WRITER = new EcmWriter();

    private DefaultLispEncapsulatedControl(boolean isSecurity, IP innerIpHeader, UDP innerUdp, LispMessage innerMessage) {
        this.isSecurity = isSecurity;
        this.innerIpHeader = innerIpHeader;
        this.innerUdp = innerUdp;
        this.innerMessage = innerMessage;
    }

    @Override
    public LispType getType() {
        return LispType.LISP_ENCAPSULATED_CONTROL;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    @Override
    public LispMessage.Builder createBuilder() {
        return new DefaultEcmBuilder();
    }

    @Override
    public boolean isSecurity() {
        return this.isSecurity;
    }

    @Override
    public IP innerIpHeader() {
        return this.innerIpHeader;
    }

    @Override
    public UDP innerUdp() {
        return this.innerUdp;
    }

    @Override
    public LispMessage getControlMessage() {
        return this.innerMessage;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("isSecurity", this.isSecurity).add("inner IP header", (Object)this.innerIpHeader).add("inner UDP header", (Object)this.innerUdp).add("inner lisp Message", (Object)this.innerMessage).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispEncapsulatedControl that = (DefaultLispEncapsulatedControl)o;
        return Objects.equal((Object)this.isSecurity, (Object)that.isSecurity) && Objects.equal((Object)this.innerIpHeader, (Object)that.innerIpHeader) && Objects.equal((Object)this.innerUdp, (Object)that.innerUdp) && Objects.equal((Object)this.innerMessage, (Object)that.innerMessage);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.isSecurity, this.innerIpHeader, this.innerUdp, this.innerMessage});
    }

    public static class EcmWriter
    implements LispMessageWriter<LispEncapsulatedControl> {
        private static final short ECM_MSG_CODE = LispType.LISP_ENCAPSULATED_CONTROL.getTypeCode();
        private static final int TYPE_SHIFT_BIT = 4;
        private static final int SECURITY_SHIFT_BIT = 3;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispEncapsulatedControl message) throws LispWriterException {
            byte msgType = (byte)(ECM_MSG_CODE << 4);
            int security = 0;
            if (message.isSecurity()) {
                security = 8;
            }
            byteBuf.writeByte(msgType + security);
            byteBuf.writeByte(0);
            byteBuf.writeByte(0);
            byteBuf.writeByte(0);
            ByteBuf buffer = Unpooled.buffer();
            message.getControlMessage().writeTo(buffer);
            byte[] dataBytes = new byte[buffer.writerIndex()];
            buffer.getBytes(0, dataBytes, 0, buffer.writerIndex());
            message.innerUdp().setPayload((IPacket)new Data(dataBytes));
            message.innerIpHeader().setPayload((IPacket)message.innerUdp());
            byteBuf.writeBytes(message.innerIpHeader().serialize());
        }
    }

    public static final class EcmReader
    implements LispMessageReader<LispEncapsulatedControl> {
        private static final int SECURITY_INDEX = 3;
        private static final int RESERVED_SKIP_LENGTH = 3;
        private static final int UDP_HEADER_LENGTH = 8;
        private static final short HEADER_LENGTH_MASK = 15;

        @Override
        public LispEncapsulatedControl readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException, DeserializationException {
            if (byteBuf.readerIndex() != 0) {
                return null;
            }
            boolean securityFlag = ByteOperator.getBit((byte)byteBuf.readByte(), (int)3);
            byteBuf.skipBytes(3);
            short totalLength = byteBuf.getShort(byteBuf.readerIndex() + 2);
            byte[] ipHeaderByte = new byte[totalLength];
            byteBuf.getBytes(byteBuf.readerIndex(), ipHeaderByte, 0, (int)totalLength);
            IP innerIpHeader = (IP)IP.deserializer().deserialize(ipHeaderByte, 0, (int)totalLength);
            UDP innerUdp = (UDP)innerIpHeader.getPayload();
            Data data = (Data)innerUdp.getPayload();
            ByteBuf msgBuffer = Unpooled.buffer();
            msgBuffer.writeBytes(data.getData());
            LispMessageReader reader = LispMessageReaderFactory.getReader(msgBuffer);
            LispMessage innerMessage = (LispMessage)reader.readFrom(msgBuffer);
            return new DefaultLispEncapsulatedControl(securityFlag, innerIpHeader, innerUdp, innerMessage);
        }
    }

    public static final class DefaultEcmBuilder
    implements LispEncapsulatedControl.EcmBuilder {
        private boolean isSecurity;
        private IP innerIpHeader;
        private UDP innerUdpHeader;
        private LispMessage innerMessage;

        @Override
        public LispType getType() {
            return LispType.LISP_ENCAPSULATED_CONTROL;
        }

        @Override
        public LispEncapsulatedControl.EcmBuilder isSecurity(boolean security) {
            this.isSecurity = security;
            return this;
        }

        @Override
        public LispEncapsulatedControl.EcmBuilder innerIpHeader(IP innerIpHeader) {
            this.innerIpHeader = innerIpHeader;
            return this;
        }

        @Override
        public LispEncapsulatedControl.EcmBuilder innerUdpHeader(UDP innerUdpHeader) {
            this.innerUdpHeader = innerUdpHeader;
            return this;
        }

        @Override
        public LispEncapsulatedControl.EcmBuilder innerLispMessage(LispMessage msg) {
            this.innerMessage = msg;
            return this;
        }

        @Override
        public LispEncapsulatedControl build() {
            return new DefaultLispEncapsulatedControl(this.isSecurity, this.innerIpHeader, this.innerUdpHeader, this.innerMessage);
        }
    }
}

