/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Arrays;
import org.onosproject.lisp.msg.authentication.LispAuthenticationFactory;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispInfo;
import org.onosproject.lisp.msg.protocols.LispInfo;
import org.onosproject.lisp.msg.protocols.LispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispType;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispNoAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLispInfoRequest
extends DefaultLispInfo
implements LispInfoRequest {
    private static final Logger log = LoggerFactory.getLogger(DefaultLispInfoRequest.class);
    static final InfoRequestWriter WRITER = new InfoRequestWriter();

    protected DefaultLispInfoRequest(boolean infoReply, long nonce, short keyId, short authDataLength, byte[] authData, int ttl, byte maskLength, LispAfiAddress eidPrefix) {
        super(infoReply, nonce, keyId, authDataLength, authData, ttl, maskLength, eidPrefix);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("nonce", this.nonce).add("keyId", (int)this.keyId).add("authentication data length", (int)this.authDataLength).add("authentication data", (Object)this.authData).add("TTL", this.ttl).add("EID mask length", (int)this.maskLength).add("EID prefix", (Object)this.eidPrefix).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispInfoRequest that = (DefaultLispInfoRequest)o;
        return Objects.equal((Object)this.nonce, (Object)that.nonce) && Objects.equal((Object)this.keyId, (Object)that.keyId) && Objects.equal((Object)this.authDataLength, (Object)that.authDataLength) && Arrays.equals(this.authData, that.authData) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)this.eidPrefix, (Object)that.eidPrefix);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.nonce, this.keyId, this.authDataLength, this.ttl, this.maskLength, this.eidPrefix}) + Arrays.hashCode(this.authData);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public static final class InfoRequestWriter
    implements LispMessageWriter<LispInfoRequest> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispInfoRequest message) throws LispWriterException {
            DefaultLispInfo.serialize(byteBuf, message);
            new LispAfiAddress.AfiAddressWriter().writeTo(byteBuf, new LispNoAddress());
        }
    }

    public static class InfoRequestReader
    implements LispMessageReader<LispInfoRequest> {
        @Override
        public LispInfoRequest readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispInfo lispInfo = DefaultLispInfo.deserialize(byteBuf);
            return ((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)new DefaultInfoRequestBuilder().withIsInfoReply(lispInfo.isInfoReply()).withNonce(lispInfo.getNonce())).withKeyId(lispInfo.getKeyId())).withAuthDataLength(lispInfo.getAuthDataLength())).withAuthData(lispInfo.getAuthData())).withTtl(lispInfo.getTtl())).withMaskLength(lispInfo.getMaskLength())).withEidPrefix(lispInfo.getPrefix())).build();
        }
    }

    public static final class DefaultInfoRequestBuilder
    implements LispInfoRequest.InfoRequestBuilder {
        private boolean infoReply;
        private long nonce;
        private short keyId;
        private short authDataLength;
        private byte[] authData;
        private String authKey;
        private int ttl;
        private byte maskLength;
        private LispAfiAddress eidPrefix;

        @Override
        public LispType getType() {
            return LispType.LISP_INFO;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withIsInfoReply(boolean infoReply) {
            this.infoReply = infoReply;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withNonce(long nonce) {
            this.nonce = nonce;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withAuthDataLength(short authDataLength) {
            this.authDataLength = authDataLength;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withKeyId(short keyId) {
            this.keyId = keyId;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withAuthData(byte[] authenticationData) {
            if (authenticationData != null) {
                this.authData = authenticationData;
            }
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withAuthKey(String key) {
            this.authKey = key;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withTtl(int ttl) {
            this.ttl = ttl;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withMaskLength(byte maskLength) {
            this.maskLength = maskLength;
            return this;
        }

        @Override
        public LispInfoRequest.InfoRequestBuilder withEidPrefix(LispAfiAddress eidPrefix) {
            this.eidPrefix = eidPrefix;
            return this;
        }

        @Override
        public LispInfoRequest build() {
            if (this.authData == null) {
                LispAuthenticationFactory factory = LispAuthenticationFactory.getInstance();
                this.authDataLength = LispAuthenticationKeyEnum.valueOf(this.keyId).getHashLength();
                byte[] tmpAuthData = new byte[this.authDataLength];
                Arrays.fill(tmpAuthData, (byte)0);
                this.authData = tmpAuthData;
                ByteBuf byteBuf = Unpooled.buffer();
                try {
                    new DefaultLispInfoRequest(this.infoReply, this.nonce, this.keyId, this.authDataLength, this.authData, this.ttl, this.maskLength, this.eidPrefix).writeTo(byteBuf);
                }
                catch (LispWriterException e) {
                    log.warn("Failed to serialize info request", (Throwable)e);
                }
                byte[] bytes = new byte[byteBuf.readableBytes()];
                byteBuf.readBytes(bytes);
                if (this.authKey == null) {
                    log.warn("Must specify authentication key");
                }
                this.authData = factory.createAuthenticationData(LispAuthenticationKeyEnum.valueOf(this.keyId), this.authKey, bytes);
            }
            return new DefaultLispInfoRequest(this.infoReply, this.nonce, this.keyId, this.authDataLength, this.authData, this.ttl, this.maskLength, this.eidPrefix);
        }
    }
}

