/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.LispLocatorRecord;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispLocatorRecord
implements LispLocatorRecord {
    private final byte priority;
    private final byte weight;
    private final byte multicastPriority;
    private final byte multicastWeight;
    private final boolean localLocator;
    private final boolean rlocProbed;
    private final boolean routed;
    private final LispAfiAddress locatorAfi;
    static final LocatorRecordWriter WRITER = new LocatorRecordWriter();

    private DefaultLispLocatorRecord(byte priority, byte weight, byte multicastPriority, byte multicastWeight, boolean localLocator, boolean rlocProbed, boolean routed, LispAfiAddress locatorAfi) {
        this.priority = priority;
        this.weight = weight;
        this.multicastPriority = multicastPriority;
        this.multicastWeight = multicastWeight;
        this.localLocator = localLocator;
        this.rlocProbed = rlocProbed;
        this.routed = routed;
        this.locatorAfi = locatorAfi;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public byte getWeight() {
        return this.weight;
    }

    @Override
    public byte getMulticastPriority() {
        return this.multicastPriority;
    }

    @Override
    public byte getMulticastWeight() {
        return this.multicastWeight;
    }

    @Override
    public boolean isLocalLocator() {
        return this.localLocator;
    }

    @Override
    public boolean isRlocProbed() {
        return this.rlocProbed;
    }

    @Override
    public boolean isRouted() {
        return this.routed;
    }

    @Override
    public LispAfiAddress getLocatorAfi() {
        return this.locatorAfi;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("priority", (int)this.priority).add("weight", (int)this.weight).add("multi-cast priority", (int)this.multicastPriority).add("multi-cast weight", (int)this.multicastWeight).add("local locator", this.localLocator).add("RLOC probed", this.rlocProbed).add("routed", this.routed).add("locator AFI", (Object)this.locatorAfi).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispLocatorRecord that = (DefaultLispLocatorRecord)o;
        return Objects.equal((Object)this.priority, (Object)that.priority) && Objects.equal((Object)this.weight, (Object)that.weight) && Objects.equal((Object)this.multicastPriority, (Object)that.multicastPriority) && Objects.equal((Object)this.multicastWeight, (Object)that.multicastWeight) && Objects.equal((Object)this.localLocator, (Object)that.localLocator) && Objects.equal((Object)this.rlocProbed, (Object)that.rlocProbed) && Objects.equal((Object)this.routed, (Object)that.routed) && Objects.equal((Object)this.locatorAfi, (Object)that.locatorAfi);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.priority, this.weight, this.multicastPriority, this.multicastWeight, this.localLocator, this.rlocProbed, this.routed, this.locatorAfi});
    }

    public static final class LocatorRecordWriter
    implements LispMessageWriter<LispLocatorRecord> {
        private static final int LOCAL_LOCATOR_SHIFT_BIT = 2;
        private static final int PROBED_SHIFT_BIT = 1;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispLocatorRecord message) throws LispWriterException {
            byteBuf.writeByte((int)message.getPriority());
            byteBuf.writeByte((int)message.getWeight());
            byteBuf.writeByte((int)message.getMulticastPriority());
            byteBuf.writeByte((int)message.getMulticastWeight());
            byteBuf.writeByte(0);
            int localLocator = 0;
            if (message.isLocalLocator()) {
                localLocator = 4;
            }
            int probed = 0;
            if (message.isRlocProbed()) {
                probed = 2;
            }
            int routed = 0;
            if (message.isRouted()) {
                routed = 1;
            }
            byteBuf.writeByte((int)((byte)(localLocator + probed + routed)));
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getLocatorAfi());
        }
    }

    public static final class LocatorRecordReader
    implements LispMessageReader<LispLocatorRecord> {
        private static final int SKIP_UNUSED_FLAG_LENGTH = 1;
        private static final int LOCAL_LOCATOR_INDEX = 2;
        private static final int RLOC_PROBED_INDEX = 1;
        private static final int ROUTED_INDEX = 0;

        @Override
        public LispLocatorRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            byte priority = (byte)byteBuf.readUnsignedByte();
            byte weight = (byte)byteBuf.readUnsignedByte();
            byte multicastPriority = (byte)byteBuf.readUnsignedByte();
            byte multicastWeight = (byte)byteBuf.readUnsignedByte();
            byteBuf.skipBytes(1);
            byte flags = byteBuf.readByte();
            boolean localLocator = ByteOperator.getBit((byte)flags, (int)2);
            boolean rlocProbed = ByteOperator.getBit((byte)flags, (int)1);
            boolean routed = ByteOperator.getBit((byte)flags, (int)0);
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new DefaultLocatorRecordBuilder().withPriority(priority).withWeight(weight).withMulticastPriority(multicastPriority).withMulticastWeight(multicastWeight).withLocalLocator(localLocator).withRlocProbed(rlocProbed).withRouted(routed).withLocatorAfi(address).build();
        }
    }

    public static final class DefaultLocatorRecordBuilder
    implements LispLocatorRecord.LocatorRecordBuilder {
        private byte priority;
        private byte weight;
        private byte multicastPriority;
        private byte multicastWeight;
        private boolean localLocator;
        private boolean rlocProbed;
        private boolean routed;
        private LispAfiAddress locatorAfi;

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withPriority(byte priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withWeight(byte weight) {
            this.weight = weight;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withMulticastPriority(byte priority) {
            this.multicastPriority = priority;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withMulticastWeight(byte weight) {
            this.multicastWeight = weight;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withLocalLocator(boolean localLocator) {
            this.localLocator = localLocator;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withRlocProbed(boolean rlocProbed) {
            this.rlocProbed = rlocProbed;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withRouted(boolean routed) {
            this.routed = routed;
            return this;
        }

        @Override
        public LispLocatorRecord.LocatorRecordBuilder withLocatorAfi(LispAfiAddress locatorAfi) {
            this.locatorAfi = locatorAfi;
            return this;
        }

        @Override
        public LispLocatorRecord build() {
            Preconditions.checkNotNull((Object)this.locatorAfi, (Object)"Must specify a locator address");
            return new DefaultLispLocatorRecord(this.priority, this.weight, this.multicastPriority, this.multicastWeight, this.localLocator, this.rlocProbed, this.routed, this.locatorAfi);
        }
    }
}

