/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispLocatorRecord;
import org.onosproject.lisp.msg.protocols.LispLocatorRecord;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispMapRecord
implements LispMapRecord {
    private final int recordTtl;
    private final byte maskLength;
    private final LispMapReplyAction action;
    private final boolean authoritative;
    private final short mapVersionNumber;
    private final LispAfiAddress eidPrefixAfi;
    private final List<LispLocatorRecord> locatorRecords;
    static final MapRecordWriter WRITER = new MapRecordWriter();

    private DefaultLispMapRecord(int recordTtl, byte maskLength, LispMapReplyAction action, boolean authoritative, short mapVersionNumber, LispAfiAddress eidPrefixAfi, List<LispLocatorRecord> locatorRecords) {
        this.recordTtl = recordTtl;
        this.maskLength = maskLength;
        this.action = action;
        this.authoritative = authoritative;
        this.mapVersionNumber = mapVersionNumber;
        this.eidPrefixAfi = eidPrefixAfi;
        this.locatorRecords = locatorRecords;
    }

    @Override
    public int getRecordTtl() {
        return this.recordTtl;
    }

    @Override
    public int getLocatorCount() {
        return this.locatorRecords.size();
    }

    @Override
    public byte getMaskLength() {
        return this.maskLength;
    }

    @Override
    public LispMapReplyAction getAction() {
        return this.action;
    }

    @Override
    public boolean isAuthoritative() {
        return this.authoritative;
    }

    @Override
    public short getMapVersionNumber() {
        return this.mapVersionNumber;
    }

    @Override
    public LispAfiAddress getEidPrefixAfi() {
        return this.eidPrefixAfi;
    }

    @Override
    public List<LispLocatorRecord> getLocators() {
        return ImmutableList.copyOf(this.locatorRecords);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("record TTL", this.recordTtl).add("maskLength", (int)this.maskLength).add("action", (Object)this.action).add("authoritative", this.authoritative).add("mapVersionNumber", (int)this.mapVersionNumber).add("EID prefix AFI address", (Object)this.eidPrefixAfi).add("locator records", this.locatorRecords).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispMapRecord that = (DefaultLispMapRecord)o;
        return Objects.equal((Object)this.recordTtl, (Object)that.recordTtl) && Objects.equal((Object)this.maskLength, (Object)that.maskLength) && Objects.equal((Object)((Object)this.action), (Object)((Object)that.action)) && Objects.equal((Object)this.authoritative, (Object)that.authoritative) && Objects.equal((Object)this.mapVersionNumber, (Object)that.mapVersionNumber) && Objects.equal((Object)this.eidPrefixAfi, (Object)that.eidPrefixAfi) && Objects.equal(this.locatorRecords, that.locatorRecords);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.locatorRecords});
    }

    public static final class MapRecordWriter
    implements LispMessageWriter<LispMapRecord> {
        private static final int REPLY_ACTION_SHIFT_BIT = 5;
        private static final int AUTHORITATIVE_FLAG_SHIFT_BIT = 4;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMapRecord message) throws LispWriterException {
            byteBuf.writeInt(message.getRecordTtl());
            byteBuf.writeByte((int)((byte)message.getLocators().size()));
            byteBuf.writeByte((int)message.getMaskLength());
            byte action = (byte)(message.getAction().getAction() << 5);
            int authoritative = 0;
            if (message.isAuthoritative()) {
                authoritative = 16;
            }
            byteBuf.writeByte((int)((byte)(action + authoritative)));
            byteBuf.writeByte(0);
            byteBuf.writeShort((int)message.getMapVersionNumber());
            LispAfiAddress.AfiAddressWriter afiAddressWriter = new LispAfiAddress.AfiAddressWriter();
            afiAddressWriter.writeTo(byteBuf, message.getEidPrefixAfi());
            DefaultLispLocatorRecord.LocatorRecordWriter recordWriter = new DefaultLispLocatorRecord.LocatorRecordWriter();
            List<LispLocatorRecord> locators = message.getLocators();
            for (int i = 0; i < locators.size(); ++i) {
                recordWriter.writeTo(byteBuf, locators.get(i));
            }
        }
    }

    public static final class MapRecordReader
    implements LispMessageReader<LispMapRecord> {
        private static final int AUTHORITATIVE_INDEX = 4;
        private static final int RESERVED_SKIP_LENGTH = 1;
        private static final int REPLY_ACTION_SHIFT_BIT = 5;

        @Override
        public LispMapRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            int recordTtl = byteBuf.readInt();
            int locatorCount = byteBuf.readUnsignedByte();
            byte maskLength = (byte)byteBuf.readUnsignedByte();
            byte actionWithFlag = (byte)byteBuf.readUnsignedByte();
            int actionByte = actionWithFlag >> 5;
            LispMapReplyAction action = LispMapReplyAction.valueOf(actionByte);
            if (action == null) {
                action = LispMapReplyAction.NoAction;
            }
            boolean authoritative = ByteOperator.getBit((byte)((byte)(actionWithFlag >> 4)), (int)0);
            byteBuf.skipBytes(1);
            short mapVersionNumber = (short)byteBuf.readUnsignedShort();
            LispAfiAddress eidPrefixAfi = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            ArrayList locators = Lists.newArrayList();
            for (int i = 0; i < locatorCount; ++i) {
                locators.add(new DefaultLispLocatorRecord.LocatorRecordReader().readFrom(byteBuf));
            }
            return new DefaultMapRecordBuilder().withRecordTtl(recordTtl).withMaskLength(maskLength).withAction(action).withAuthoritative(authoritative).withMapVersionNumber(mapVersionNumber).withLocators(locators).withEidPrefixAfi(eidPrefixAfi).build();
        }
    }

    public static final class DefaultMapRecordBuilder
    implements LispMapRecord.MapRecordBuilder {
        private int recordTtl;
        private byte maskLength;
        private LispMapReplyAction action;
        private boolean authoritative;
        private short mapVersionNumber;
        private LispAfiAddress eidPrefixAfi;
        private List<LispLocatorRecord> locatorRecords = Lists.newArrayList();

        @Override
        public LispMapRecord.MapRecordBuilder withRecordTtl(int recordTtl) {
            this.recordTtl = recordTtl;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withMaskLength(byte maskLength) {
            this.maskLength = maskLength;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withAction(LispMapReplyAction action) {
            this.action = action;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withAuthoritative(boolean authoritative) {
            this.authoritative = authoritative;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withMapVersionNumber(short mapVersionNumber) {
            this.mapVersionNumber = mapVersionNumber;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withEidPrefixAfi(LispAfiAddress prefix) {
            this.eidPrefixAfi = prefix;
            return this;
        }

        @Override
        public LispMapRecord.MapRecordBuilder withLocators(List<LispLocatorRecord> records) {
            if (records != null) {
                this.locatorRecords = ImmutableList.copyOf(records);
            }
            return this;
        }

        @Override
        public LispMapRecord build() {
            Preconditions.checkNotNull((Object)this.eidPrefixAfi, (Object)"Must specify an EID prefix");
            return new DefaultLispMapRecord(this.recordTtl, this.maskLength, this.action, this.authoritative, this.mapVersionNumber, this.eidPrefixAfi, this.locatorRecords);
        }
    }
}

