/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class LispDistinguishedNameAddress
extends LispAfiAddress {
    private final String distinguishedName;

    public LispDistinguishedNameAddress(String distinguishedName) {
        super(AddressFamilyIdentifierEnum.DISTINGUISHED_NAME);
        this.distinguishedName = distinguishedName;
    }

    public String getDistinguishedName() {
        return this.distinguishedName;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.distinguishedName);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispDistinguishedNameAddress) {
            LispDistinguishedNameAddress other = (LispDistinguishedNameAddress)obj;
            return Objects.equals(this.distinguishedName, other.distinguishedName);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("distinguished name", (Object)this.distinguishedName).toString();
    }

    public static class DistinguishedNameAddressWriter
    implements LispAddressWriter<LispDistinguishedNameAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispDistinguishedNameAddress address) throws LispWriterException {
            String distinguishedName = address.getDistinguishedName();
            byte[] nameBytes = distinguishedName.getBytes();
            for (int i = 0; i < nameBytes.length; ++i) {
                byteBuf.writeByte((int)nameBytes[i]);
            }
        }
    }

    public static class DistinguishedNameAddressReader
    implements LispAddressReader<LispDistinguishedNameAddress> {
        @Override
        public LispDistinguishedNameAddress readFrom(ByteBuf byteBuf) throws LispParseError {
            StringBuilder sb = new StringBuilder();
            while (byteBuf.readerIndex() < byteBuf.writerIndex()) {
                byte character = byteBuf.readByte();
                sb.append((char)character);
            }
            return new LispDistinguishedNameAddress(sb.toString());
        }
    }
}

