/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispIpAddress;

public class LispIpv6Address
extends LispIpAddress {
    public LispIpv6Address(IpAddress address) {
        super(address, AddressFamilyIdentifierEnum.IP6);
        Preconditions.checkArgument((boolean)address.isIp6());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispIpv6Address) {
            LispIpv6Address other = (LispIpv6Address)obj;
            return Objects.equals(this.address, other.address) && Objects.equals((Object)this.getAfi(), (Object)other.getAfi());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.getAfi()});
    }

    public static class Ipv6AddressWriter
    implements LispAddressWriter<LispIpv6Address> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispIpv6Address address) throws LispWriterException {
            byte[] ipByte = address.getAddress().getIp6Address().toOctets();
            byteBuf.writeBytes(ipByte);
        }
    }

    public static class Ipv6AddressReader
    implements LispAddressReader<LispIpv6Address> {
        private static final int SIZE_OF_IPV6_ADDRESS = 16;

        @Override
        public LispIpv6Address readFrom(ByteBuf byteBuf) throws LispParseError {
            byte[] ipByte = new byte[16];
            byteBuf.readBytes(ipByte);
            IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET6, (byte[])ipByte);
            return new LispIpv6Address(ipAddress);
        }
    }
}

