/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispLcafAddress;

public final class LispListLcafAddress
extends LispLcafAddress {
    private static final short LENGTH = 24;
    List<LispAfiAddress> addresses;

    public LispListLcafAddress(List<LispAfiAddress> addresses) {
        super(LispCanonicalAddressFormatEnum.LIST, (short)24);
        Preconditions.checkArgument((boolean)this.checkAddressValidity(addresses), (Object)"Malformed addresses, please specify IPv4 address first, and then specify IPv6 address");
        this.addresses = addresses;
    }

    public LispListLcafAddress(byte reserved1, byte reserved2, byte flag, List<LispAfiAddress> addresses) {
        super(LispCanonicalAddressFormatEnum.LIST, reserved1, flag, reserved2, (short)24);
        Preconditions.checkArgument((boolean)this.checkAddressValidity(addresses), (Object)"Malformed addresses, please specify IPv4 address first, and then specify IPv6 address");
        this.addresses = addresses;
    }

    private boolean checkAddressValidity(List<LispAfiAddress> addresses) {
        if (addresses == null || addresses.size() != 2) {
            return false;
        }
        LispAfiAddress ipv4 = addresses.get(0);
        LispAfiAddress ipv6 = addresses.get(1);
        if (ipv4.getAfi() != AddressFamilyIdentifierEnum.IP4) {
            return false;
        }
        return ipv6.getAfi() == AddressFamilyIdentifierEnum.IP6;
    }

    public List<LispAfiAddress> getAddresses() {
        return ImmutableList.copyOf(this.addresses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.addresses);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispListLcafAddress) {
            LispListLcafAddress other = (LispListLcafAddress)obj;
            return Objects.equals(this.addresses, other.addresses);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("addresses", this.addresses).toString();
    }

    public static class ListLcafAddressWriter
    implements LispAddressWriter<LispListLcafAddress> {
        private static final int IPV4_ADDRESS_INDEX = 0;
        private static final int IPV6_ADDRESS_INDEX = 1;

        @Override
        public void writeTo(ByteBuf byteBuf, LispListLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            LispIpv4Address.Ipv4AddressWriter v4Writer = new LispIpv4Address.Ipv4AddressWriter();
            LispIpv6Address.Ipv6AddressWriter v6Writer = new LispIpv6Address.Ipv6AddressWriter();
            LispAfiAddress ipv4 = address.getAddresses().get(0);
            LispAfiAddress ipv6 = address.getAddresses().get(1);
            byteBuf.writeShort((int)ipv4.getAfi().getIanaCode());
            v4Writer.writeTo(byteBuf, (LispIpv4Address)ipv4);
            byteBuf.writeShort((int)ipv6.getAfi().getIanaCode());
            v6Writer.writeTo(byteBuf, (LispIpv6Address)ipv6);
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class ListLcafAddressReader
    implements LispAddressReader<LispListLcafAddress> {
        @Override
        public LispListLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress lcafAddress = LispLcafAddress.deserializeCommon(byteBuf);
            LispAfiAddress.AfiAddressReader reader = new LispAfiAddress.AfiAddressReader();
            LispAfiAddress ipv4 = reader.readFrom(byteBuf);
            LispAfiAddress ipv6 = reader.readFrom(byteBuf);
            return new LispListLcafAddress(lcafAddress.getReserved1(), lcafAddress.getReserved2(), lcafAddress.getFlag(), (List<LispAfiAddress>)ImmutableList.of((Object)ipv4, (Object)ipv6));
        }
    }
}

