/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.LispLcafAddress;

public final class LispSegmentLcafAddress
extends LispLcafAddress {
    private final LispAfiAddress address;
    private final int instanceId;

    private LispSegmentLcafAddress(byte idMaskLength, int instanceId, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.SEGMENT, idMaskLength);
        this.address = address;
        this.instanceId = instanceId;
    }

    private LispSegmentLcafAddress(byte reserved1, byte idMaskLength, byte flag, short length, int instanceId, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.SEGMENT, reserved1, idMaskLength, flag, length);
        this.address = address;
        this.instanceId = instanceId;
    }

    public LispAfiAddress getAddress() {
        return this.address;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public byte getIdMaskLength() {
        return this.getReserved2();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.address, this.instanceId, this.getReserved2());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispSegmentLcafAddress) {
            LispSegmentLcafAddress other = (LispSegmentLcafAddress)obj;
            return Objects.equals(this.address, other.address) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.getReserved2(), other.getReserved2());
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("address", (Object)this.address).add("instanceId", this.instanceId).add("idMaskLength", (int)this.getReserved2()).toString();
    }

    public static class SegmentLcafAddressWriter
    implements LispAddressWriter<LispSegmentLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispSegmentLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeInt(address.getInstanceId());
            new LispAfiAddress.AfiAddressWriter().writeTo(byteBuf, address.getAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class SegmentLcafAddressReader
    implements LispAddressReader<LispSegmentLcafAddress> {
        @Override
        public LispSegmentLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress lcafAddress = LispLcafAddress.deserializeCommon(byteBuf);
            byte idMaskLength = lcafAddress.getReserved2();
            int instanceId = (int)byteBuf.readUnsignedInt();
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return ((SegmentAddressBuilder)((SegmentAddressBuilder)((SegmentAddressBuilder)new SegmentAddressBuilder().withReserved1(lcafAddress.getReserved1())).withFlag(lcafAddress.getFlag())).withLength(lcafAddress.getLength())).withIdMaskLength(idMaskLength).withInstanceId(instanceId).withAddress(address).build();
        }
    }

    public static final class SegmentAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<SegmentAddressBuilder> {
        private byte idMaskLength;
        private LispAfiAddress address;
        private int instanceId;

        public SegmentAddressBuilder withIdMaskLength(byte idMaskLength) {
            this.idMaskLength = idMaskLength;
            return this;
        }

        public SegmentAddressBuilder withInstanceId(int instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public SegmentAddressBuilder withAddress(LispAfiAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public LispSegmentLcafAddress build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Must specify an address");
            return new LispSegmentLcafAddress(this.reserved1, this.idMaskLength, this.flag, this.length, this.instanceId, this.address);
        }
    }
}

