/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class LispTeRecord {
    private final boolean lookup;
    private final boolean rlocProbe;
    private final boolean strict;
    private final LispAfiAddress rtrRlocAddress;

    public LispTeRecord(boolean lookup, boolean rlocProbe, boolean strict, LispAfiAddress rtrAddress) {
        this.lookup = lookup;
        this.rlocProbe = rlocProbe;
        this.strict = strict;
        this.rtrRlocAddress = rtrAddress;
    }

    public boolean isLookup() {
        return this.lookup;
    }

    public boolean isRlocProbe() {
        return this.rlocProbe;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public LispAfiAddress getRtrRlocAddress() {
        return this.rtrRlocAddress;
    }

    public int hashCode() {
        return Objects.hash(this.lookup, this.rlocProbe, this.strict, this.rtrRlocAddress);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispTeRecord) {
            LispTeRecord other = (LispTeRecord)obj;
            return Objects.equals(this.lookup, other.lookup) && Objects.equals(this.rlocProbe, other.rlocProbe) && Objects.equals(this.strict, other.strict) && Objects.equals(this.rtrRlocAddress, other.rtrRlocAddress);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Lookup bit", this.lookup).add("RLOC probe bit", this.rlocProbe).add("strict bit", this.strict).add("RTR address", (Object)this.rtrRlocAddress).toString();
    }

    public static class TeRecordWriter
    implements LispAddressWriter<LispTeRecord> {
        private static final int LOOKUP_FLAG_SHIFT_BIT = 3;
        private static final int RLOC_PROBE_FLAG_SHIFT_BIT = 2;
        private static final int STRICT_FLAG_SHIFT_BIT = 1;
        private static final int ENABLE_BIT = 1;
        private static final int DISABLE_BIT = 0;
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispTeRecord record) throws LispWriterException {
            byteBuf.writeByte(0);
            int lookup = 0;
            if (record.isLookup()) {
                lookup = 8;
            }
            int rlocProbe = 0;
            if (record.isRlocProbe()) {
                rlocProbe = 4;
            }
            int strict = 0;
            if (record.isStrict()) {
                strict = 2;
            }
            byteBuf.writeByte((int)((byte)(lookup + rlocProbe + strict)));
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, record.rtrRlocAddress);
        }
    }

    public static class TeRecordReader
    implements LispAddressReader<LispTeRecord> {
        private static final int RESERVED_SKIP_LENGTH = 1;
        private static final int STRICT_INDEX = 1;
        private static final int RLOC_PROBE_INDEX = 2;
        private static final int LOOKUP_INDEX = 3;

        @Override
        public LispTeRecord readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            byteBuf.skipBytes(1);
            byte flags = byteBuf.readByte();
            boolean lookup = ByteOperator.getBit((byte)flags, (int)3);
            boolean rlocProbe = ByteOperator.getBit((byte)flags, (int)2);
            boolean strict = ByteOperator.getBit((byte)flags, (int)1);
            LispAfiAddress.AfiAddressReader reader = new LispAfiAddress.AfiAddressReader();
            LispAfiAddress rtrAddress = reader.readFrom(byteBuf);
            return new LispTeRecord(lookup, rlocProbe, strict, rtrAddress);
        }
    }

    public static final class TeRecordBuilder {
        private boolean lookup;
        private boolean rlocProbe;
        private boolean strict;
        private LispAfiAddress rtrRlocAddress;

        public TeRecordBuilder withIsLookup(boolean lookup) {
            this.lookup = lookup;
            return this;
        }

        public TeRecordBuilder withIsRlocProbe(boolean rlocProbe) {
            this.rlocProbe = rlocProbe;
            return this;
        }

        public TeRecordBuilder withIsStrict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public TeRecordBuilder withRtrRlocAddress(LispAfiAddress rtrRlocAddress) {
            this.rtrRlocAddress = rtrRlocAddress;
            return this;
        }

        public LispTeRecord build() {
            return new LispTeRecord(this.lookup, this.rlocProbe, this.strict, this.rtrRlocAddress);
        }
    }
}

