/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.authentication;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.lisp.msg.authentication.LispAuthenticationFactory;
import org.onosproject.lisp.msg.authentication.LispAuthenticationKeyEnum;
import org.onosproject.lisp.msg.authentication.LispMacAuthentication;

public class LispAuthenticationTest {
    private LispAuthenticationFactory factory;

    @Before
    public void setup() {
        this.factory = LispAuthenticationFactory.getInstance();
    }

    @Test
    public void testAuthData() {
        String authKey = "testKey";
        byte[] noneAuthData = this.factory.createAuthenticationData(LispAuthenticationKeyEnum.NONE, authKey, new byte[0]);
        byte[] unknownAuthData = this.factory.createAuthenticationData(LispAuthenticationKeyEnum.UNKNOWN, authKey, new byte[0]);
        byte[] sha1AuthData = this.factory.createAuthenticationData(LispAuthenticationKeyEnum.SHA1, authKey, new byte[0]);
        byte[] sha256AuthData = this.factory.createAuthenticationData(LispAuthenticationKeyEnum.SHA256, authKey, new byte[0]);
        MatcherAssert.assertThat((Object)noneAuthData, (Matcher)Matchers.is((Object)new byte[0]));
        MatcherAssert.assertThat((Object)unknownAuthData, (Matcher)Matchers.is((Object)new byte[0]));
        MatcherAssert.assertThat((Object)sha1AuthData.length, (Matcher)Matchers.is((Object)20));
        MatcherAssert.assertThat((Object)sha256AuthData.length, (Matcher)Matchers.is((Object)32));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAuthType() {
        LispAuthenticationKeyEnum authType = LispAuthenticationKeyEnum.valueOf((short)0);
        LispMacAuthentication macAuth = new LispMacAuthentication(authType);
        macAuth.getAuthenticationData("onos", new byte[0]);
    }

    @Test(expected=NullPointerException.class)
    public void testNullAuthKey() {
        LispAuthenticationKeyEnum authType = LispAuthenticationKeyEnum.valueOf((short)1);
        LispMacAuthentication macAuth = new LispMacAuthentication(authType);
        macAuth.getAuthenticationData(null, new byte[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidAuthKey() {
        LispAuthenticationKeyEnum authType = LispAuthenticationKeyEnum.valueOf((short)1);
        LispMacAuthentication macAuth = new LispMacAuthentication(authType);
        macAuth.getAuthenticationData("", new byte[0]);
    }
}

