/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.IP;
import org.onlab.packet.IPv4;
import org.onlab.packet.IpAddress;
import org.onlab.packet.UDP;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRegister;
import org.onosproject.lisp.msg.protocols.LispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.protocols.LispMessage;
import org.onosproject.lisp.msg.protocols.LispType;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispEncapsulatedControlTest {
    private static final String ECM1_SRC_IP = "192.168.1.1";
    private static final String ECM1_DST_IP = "192.168.1.2";
    private static final String ECM2_SRC_IP = "192.168.2.1";
    private static final String ECM2_DST_IP = "192.168.2.2";
    private static final String RECORD_EID = "1.1.1.1";
    private static final String AUTH_KEY = "onos";
    private LispEncapsulatedControl ecm1;
    private LispEncapsulatedControl sameAsEcm1;
    private LispEncapsulatedControl ecm2;

    @Before
    public void setup() {
        DefaultLispEncapsulatedControl.DefaultEcmBuilder builder1 = new DefaultLispEncapsulatedControl.DefaultEcmBuilder();
        IPv4 innerIp1 = new IPv4().setSourceAddress(ECM1_SRC_IP).setDestinationAddress(ECM1_DST_IP).setProtocol((byte)17).setVersion((byte)4);
        UDP innerUdp1 = new UDP().setSourcePort(1).setDestinationPort(2);
        DefaultLispMapRegister.DefaultRegisterBuilder msgBuilder = new DefaultLispMapRegister.DefaultRegisterBuilder();
        ImmutableList records1 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        LispMapRegister innerMsg1 = msgBuilder.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records1).build();
        this.ecm1 = builder1.isSecurity(false).innerIpHeader((IP)innerIp1).innerUdpHeader(innerUdp1).innerLispMessage((LispMessage)innerMsg1).build();
        DefaultLispEncapsulatedControl.DefaultEcmBuilder builder2 = new DefaultLispEncapsulatedControl.DefaultEcmBuilder();
        IPv4 innerIp2 = new IPv4().setSourceAddress(ECM1_SRC_IP).setDestinationAddress(ECM1_DST_IP).setProtocol((byte)17);
        UDP innerUdp2 = new UDP().setSourcePort(1).setDestinationPort(2);
        DefaultLispMapRegister.DefaultRegisterBuilder msgBuilder2 = new DefaultLispMapRegister.DefaultRegisterBuilder();
        ImmutableList records2 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        LispMapRegister innerMsg2 = msgBuilder2.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records2).build();
        this.sameAsEcm1 = builder2.isSecurity(false).innerIpHeader((IP)innerIp2).innerUdpHeader(innerUdp2).innerLispMessage((LispMessage)innerMsg2).build();
        DefaultLispEncapsulatedControl.DefaultEcmBuilder builder3 = new DefaultLispEncapsulatedControl.DefaultEcmBuilder();
        IPv4 innerIp3 = new IPv4().setSourceAddress(ECM2_SRC_IP).setDestinationAddress(ECM2_DST_IP).setProtocol((byte)17);
        UDP innerUdp3 = new UDP().setSourcePort(10).setDestinationPort(20);
        DefaultLispMapRegister.DefaultRegisterBuilder msgBuilder3 = new DefaultLispMapRegister.DefaultRegisterBuilder();
        ImmutableList records3 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        LispMapRegister innerMsg3 = msgBuilder3.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)2).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records3).build();
        this.ecm2 = builder3.isSecurity(false).innerIpHeader((IP)innerIp3).innerUdpHeader(innerUdp3).innerLispMessage((LispMessage)innerMsg3).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.ecm1, this.sameAsEcm1}).addEqualityGroup(new Object[]{this.ecm2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispEncapsulatedControl ecm = (DefaultLispEncapsulatedControl)this.ecm1;
        MatcherAssert.assertThat((String)"Inner Ip versions are not match", (Object)ecm.innerIpHeader().getVersion(), (Matcher)Matchers.is((Object)4));
        MatcherAssert.assertThat((String)"Inner Ip protocols are not match", (Object)((IPv4)ecm.innerIpHeader()).getProtocol(), (Matcher)Matchers.is((Object)17));
        MatcherAssert.assertThat((String)"Inner IP source addresses are not match", (Object)((IPv4)ecm.innerIpHeader()).getSourceAddress(), (Matcher)Matchers.is((Object)IPv4.toIPv4Address((String)ECM1_SRC_IP)));
        MatcherAssert.assertThat((String)"Inner IP destination addresses are not match", (Object)((IPv4)ecm.innerIpHeader()).getDestinationAddress(), (Matcher)Matchers.is((Object)IPv4.toIPv4Address((String)ECM1_DST_IP)));
        MatcherAssert.assertThat((String)"Inner UDP source ports are not match", (Object)ecm.innerUdp().getSourcePort(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Inner UDP destination ports are not match", (Object)ecm.innerUdp().getDestinationPort(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((String)"Inner LISP control messages are not match", (Object)ecm.getControlMessage().getType(), (Matcher)Matchers.is((Object)LispType.LISP_MAP_REGISTER));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError, DeserializationException {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispEncapsulatedControl.EcmWriter writer = new DefaultLispEncapsulatedControl.EcmWriter();
        writer.writeTo(byteBuf, this.ecm1);
        DefaultLispEncapsulatedControl.EcmReader reader = new DefaultLispEncapsulatedControl.EcmReader();
        LispEncapsulatedControl deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.ecm1, deserialized}).testEquals();
    }

    private LispMapRecord getMapRecord() {
        DefaultLispMapRecord.DefaultMapRecordBuilder builder1 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)RECORD_EID));
        return builder1.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
    }
}

