/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoReply;
import org.onosproject.lisp.msg.protocols.LispInfoReply;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispNatLcafAddress;

public final class DefaultLispInfoReplyTest {
    private LispInfoReply reply1;
    private LispInfoReply sameAsReply1;
    private LispInfoReply reply2;
    private static final String AUTH_KEY = "onos";

    @Before
    public void setup() {
        DefaultLispInfoReply.DefaultInfoReplyBuilder builder1 = new DefaultLispInfoReply.DefaultInfoReplyBuilder();
        short msUdpPortNumber1 = 80;
        short etrUdpPortNumber1 = 100;
        LispIpv4Address globalEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address msRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        LispIpv4Address privateEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.3"));
        LispIpv4Address address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.4"));
        LispNatLcafAddress natLcafAddress1 = ((LispNatLcafAddress.NatAddressBuilder)new LispNatLcafAddress.NatAddressBuilder().withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber1).withEtrUdpPortNumber(etrUdpPortNumber1).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress1).withMsRlocAddress((LispAfiAddress)msRlocAddress1).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress1).build();
        this.reply1 = ((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)builder1.withNonce(1L)).withKeyId((short)1)).withAuthKey(AUTH_KEY)).withIsInfoReply(true)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address1)).withNatLcafAddress(natLcafAddress1).build();
        DefaultLispInfoReply.DefaultInfoReplyBuilder builder2 = new DefaultLispInfoReply.DefaultInfoReplyBuilder();
        this.sameAsReply1 = ((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)builder2.withNonce(1L)).withKeyId((short)1)).withAuthKey(AUTH_KEY)).withIsInfoReply(true)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address1)).withNatLcafAddress(natLcafAddress1).build();
        DefaultLispInfoReply.DefaultInfoReplyBuilder builder3 = new DefaultLispInfoReply.DefaultInfoReplyBuilder();
        short msUdpPortNumber2 = 81;
        short etrUdpPortNumber2 = 101;
        LispIpv4Address globalEtrRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        LispIpv4Address msRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.2"));
        LispIpv4Address privateEtrRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.3"));
        LispIpv4Address address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.4"));
        LispNatLcafAddress natLcafAddress2 = ((LispNatLcafAddress.NatAddressBuilder)new LispNatLcafAddress.NatAddressBuilder().withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber2).withEtrUdpPortNumber(etrUdpPortNumber2).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress2).withMsRlocAddress((LispAfiAddress)msRlocAddress2).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress2).build();
        this.reply2 = ((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)((LispInfoReply.InfoReplyBuilder)builder3.withNonce(2L)).withKeyId((short)2)).withAuthKey(AUTH_KEY)).withIsInfoReply(true)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address2)).withNatLcafAddress(natLcafAddress2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.reply1, this.sameAsReply1}).addEqualityGroup(new Object[]{this.reply2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispInfoReply reply = (DefaultLispInfoReply)this.reply1;
        LispIpv4Address address = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.4"));
        short msUdpPortNumber1 = 80;
        short etrUdpPortNumber1 = 100;
        LispIpv4Address globalEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address msRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        LispIpv4Address privateEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.3"));
        LispNatLcafAddress natLcafAddress = ((LispNatLcafAddress.NatAddressBuilder)new LispNatLcafAddress.NatAddressBuilder().withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber1).withEtrUdpPortNumber(etrUdpPortNumber1).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress1).withMsRlocAddress((LispAfiAddress)msRlocAddress1).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress1).build();
        MatcherAssert.assertThat((Object)reply.isInfoReply(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)reply.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reply.getKeyId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reply.getMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)reply.getPrefix(), (Matcher)Matchers.is((Object)address));
        MatcherAssert.assertThat((Object)reply.getNatLcafAddress(), (Matcher)Matchers.is((Object)natLcafAddress));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispInfoReply.InfoReplyWriter writer = new DefaultLispInfoReply.InfoReplyWriter();
        writer.writeTo(byteBuf, this.reply1);
        DefaultLispInfoReply.InfoReplyReader reader = new DefaultLispInfoReply.InfoReplyReader();
        LispInfoReply deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.reply1, deserialized}).testEquals();
    }
}

