/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoRequest;
import org.onosproject.lisp.msg.protocols.LispInfoRequest;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispInfoRequestTest {
    private LispInfoRequest request1;
    private LispInfoRequest sameAsRequest1;
    private LispInfoRequest request2;
    private static final String AUTH_KEY = "onos";

    @Before
    public void setup() {
        DefaultLispInfoRequest.DefaultInfoRequestBuilder builder1 = new DefaultLispInfoRequest.DefaultInfoRequestBuilder();
        LispIpv4Address address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.request1 = ((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)builder1.withNonce(1L)).withKeyId((short)1)).withAuthKey(AUTH_KEY)).withIsInfoReply(false)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address1)).build();
        DefaultLispInfoRequest.DefaultInfoRequestBuilder builder2 = new DefaultLispInfoRequest.DefaultInfoRequestBuilder();
        this.sameAsRequest1 = ((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)builder2.withNonce(1L)).withKeyId((short)1)).withAuthKey(AUTH_KEY)).withIsInfoReply(false)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address1)).build();
        DefaultLispInfoRequest.DefaultInfoRequestBuilder builder3 = new DefaultLispInfoRequest.DefaultInfoRequestBuilder();
        LispIpv4Address address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        this.request2 = ((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)((LispInfoRequest.InfoRequestBuilder)builder3.withNonce(2L)).withKeyId((short)2)).withAuthKey(AUTH_KEY)).withIsInfoReply(true)).withMaskLength((byte)1)).withEidPrefix((LispAfiAddress)address2)).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.request1, this.sameAsRequest1}).addEqualityGroup(new Object[]{this.request2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispInfoRequest request = (DefaultLispInfoRequest)this.request1;
        LispIpv4Address address = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        MatcherAssert.assertThat((Object)request.isInfoReply(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)request.getKeyId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)request.getMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)request.getPrefix(), (Matcher)Matchers.is((Object)address));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispInfoRequest.InfoRequestWriter writer = new DefaultLispInfoRequest.InfoRequestWriter();
        writer.writeTo(byteBuf, this.request1);
        DefaultLispInfoRequest.InfoRequestReader reader = new DefaultLispInfoRequest.InfoRequestReader();
        LispInfoRequest deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.request1, deserialized}).testEquals();
    }
}

