/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispLocatorRecord;
import org.onosproject.lisp.msg.protocols.LispLocatorRecord;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispLocatorRecordTest {
    private LispLocatorRecord record1;
    private LispLocatorRecord sameAsRecord1;
    private LispLocatorRecord record2;

    @Before
    public void setup() {
        DefaultLispLocatorRecord.DefaultLocatorRecordBuilder builder1 = new DefaultLispLocatorRecord.DefaultLocatorRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.record1 = builder1.withPriority((byte)1).withWeight((byte)1).withMulticastPriority((byte)1).withMulticastWeight((byte)1).withLocalLocator(true).withRlocProbed(false).withRouted(true).withLocatorAfi((LispAfiAddress)ipv4Locator1).build();
        DefaultLispLocatorRecord.DefaultLocatorRecordBuilder builder2 = new DefaultLispLocatorRecord.DefaultLocatorRecordBuilder();
        this.sameAsRecord1 = builder2.withPriority((byte)1).withWeight((byte)1).withMulticastPriority((byte)1).withMulticastWeight((byte)1).withLocalLocator(true).withRlocProbed(false).withRouted(true).withLocatorAfi((LispAfiAddress)ipv4Locator1).build();
        DefaultLispLocatorRecord.DefaultLocatorRecordBuilder builder3 = new DefaultLispLocatorRecord.DefaultLocatorRecordBuilder();
        LispIpv4Address ipv4Locator2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        this.record2 = builder3.withPriority((byte)2).withWeight((byte)2).withMulticastPriority((byte)2).withMulticastWeight((byte)2).withLocalLocator(false).withRlocProbed(true).withRouted(false).withLocatorAfi((LispAfiAddress)ipv4Locator2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.record1, this.sameAsRecord1}).addEqualityGroup(new Object[]{this.record2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispLocatorRecord record = (DefaultLispLocatorRecord)this.record1;
        LispIpv4Address ipv4Locator = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        MatcherAssert.assertThat((Object)record.getPriority(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.getWeight(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.getMulticastPriority(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.getMulticastWeight(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.isLocalLocator(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)record.isRlocProbed(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)record.isRouted(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)record.getLocatorAfi(), (Matcher)Matchers.is((Object)ipv4Locator));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispLocatorRecord.LocatorRecordWriter writer = new DefaultLispLocatorRecord.LocatorRecordWriter();
        writer.writeTo(byteBuf, this.record1);
        DefaultLispLocatorRecord.LocatorRecordReader reader = new DefaultLispLocatorRecord.LocatorRecordReader();
        LispLocatorRecord deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.record1, deserialized}).testEquals();
    }
}

