/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispMapNotify;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapNotify;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispMapNotifyTest {
    private LispMapNotify notify1;
    private LispMapNotify sameAsNotify1;
    private LispMapNotify notify2;
    private static final String AUTH_KEY = "onos";

    @Before
    public void setup() {
        DefaultLispMapNotify.DefaultNotifyBuilder builder1 = new DefaultLispMapNotify.DefaultNotifyBuilder();
        ImmutableList records1 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.notify1 = builder1.withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records1).build();
        DefaultLispMapNotify.DefaultNotifyBuilder builder2 = new DefaultLispMapNotify.DefaultNotifyBuilder();
        ImmutableList records2 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.sameAsNotify1 = builder2.withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records2).build();
        DefaultLispMapNotify.DefaultNotifyBuilder builder3 = new DefaultLispMapNotify.DefaultNotifyBuilder();
        this.notify2 = builder3.withKeyId((short)2).withAuthKey(AUTH_KEY).withNonce(2L).build();
    }

    private LispMapRecord getMapRecord() {
        DefaultLispMapRecord.DefaultMapRecordBuilder builder1 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        return builder1.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.notify1, this.sameAsNotify1}).addEqualityGroup(new Object[]{this.notify2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispMapNotify notify = (DefaultLispMapNotify)this.notify1;
        MatcherAssert.assertThat((Object)notify.getKeyId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)notify.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)notify.getRecordCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispMapNotify.NotifyWriter writer = new DefaultLispMapNotify.NotifyWriter();
        writer.writeTo(byteBuf, this.notify1);
        DefaultLispMapNotify.NotifyReader reader = new DefaultLispMapNotify.NotifyReader();
        LispMapNotify deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.notify1, deserialized}).testEquals();
    }
}

