/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispMapRecordTest {
    private LispMapRecord record1;
    private LispMapRecord sameAsRecord1;
    private LispMapRecord record2;

    @Before
    public void setup() {
        DefaultLispMapRecord.DefaultMapRecordBuilder builder1 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.record1 = builder1.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
        DefaultLispMapRecord.DefaultMapRecordBuilder builder2 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        this.sameAsRecord1 = builder2.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
        DefaultLispMapRecord.DefaultMapRecordBuilder builder3 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        this.record2 = builder3.withRecordTtl(200).withAuthoritative(false).withMapVersionNumber((short)2).withMaskLength((byte)2).withAction(LispMapReplyAction.Drop).withEidPrefixAfi((LispAfiAddress)ipv4Locator2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.record1, this.sameAsRecord1}).addEqualityGroup(new Object[]{this.record2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispMapRecord record = (DefaultLispMapRecord)this.record1;
        LispIpv4Address ipv4Locator = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        MatcherAssert.assertThat((Object)record.getRecordTtl(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)record.isAuthoritative(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)record.getMapVersionNumber(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.getMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)record.getAction(), (Matcher)Matchers.is((Object)LispMapReplyAction.NativelyForward));
        MatcherAssert.assertThat((Object)record.getEidPrefixAfi(), (Matcher)Matchers.is((Object)ipv4Locator));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispMapRecord.MapRecordWriter writer = new DefaultLispMapRecord.MapRecordWriter();
        writer.writeTo(byteBuf, this.record1);
        DefaultLispMapRecord.MapRecordReader reader = new DefaultLispMapRecord.MapRecordReader();
        LispMapRecord deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.record1, deserialized}).testEquals();
    }
}

