/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapRegister;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispMapRegisterTest {
    private LispMapRegister register1;
    private LispMapRegister sameAsRegister1;
    private LispMapRegister register2;
    private static final String AUTH_KEY = "onos";

    @Before
    public void setup() {
        DefaultLispMapRegister.DefaultRegisterBuilder builder1 = new DefaultLispMapRegister.DefaultRegisterBuilder();
        ImmutableList records1 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.register1 = builder1.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records1).build();
        DefaultLispMapRegister.DefaultRegisterBuilder builder2 = new DefaultLispMapRegister.DefaultRegisterBuilder();
        ImmutableList records2 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.sameAsRegister1 = builder2.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)1).withAuthKey(AUTH_KEY).withNonce(1L).withMapRecords((List)records2).build();
        DefaultLispMapRegister.DefaultRegisterBuilder builder3 = new DefaultLispMapRegister.DefaultRegisterBuilder();
        this.register2 = builder3.withIsProxyMapReply(true).withIsWantMapNotify(false).withKeyId((short)2).withAuthKey(AUTH_KEY).withNonce(2L).build();
    }

    private LispMapRecord getMapRecord() {
        DefaultLispMapRecord.DefaultMapRecordBuilder builder1 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        return builder1.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.register1, this.sameAsRegister1}).addEqualityGroup(new Object[]{this.register2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispMapRegister register = (DefaultLispMapRegister)this.register1;
        MatcherAssert.assertThat((Object)register.isProxyMapReply(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)register.isWantMapNotify(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)register.getKeyId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)register.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)register.getRecordCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispMapRegister.RegisterWriter writer = new DefaultLispMapRegister.RegisterWriter();
        writer.writeTo(byteBuf, this.register1);
        DefaultLispMapRegister.RegisterReader reader = new DefaultLispMapRegister.RegisterReader();
        LispMapRegister deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.register1, deserialized}).testEquals();
    }
}

