/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRecord;
import org.onosproject.lisp.msg.protocols.DefaultLispMapReply;
import org.onosproject.lisp.msg.protocols.LispMapRecord;
import org.onosproject.lisp.msg.protocols.LispMapReply;
import org.onosproject.lisp.msg.protocols.LispMapReplyAction;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispMapReplyTest {
    private LispMapReply reply1;
    private LispMapReply sameAsReply1;
    private LispMapReply reply2;

    @Before
    public void setup() {
        DefaultLispMapReply.DefaultReplyBuilder builder1 = new DefaultLispMapReply.DefaultReplyBuilder();
        ImmutableList records1 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.reply1 = builder1.withIsEtr(true).withIsProbe(false).withIsSecurity(true).withNonce(1L).withMapRecords((List)records1).build();
        DefaultLispMapReply.DefaultReplyBuilder builder2 = new DefaultLispMapReply.DefaultReplyBuilder();
        ImmutableList records2 = ImmutableList.of((Object)this.getMapRecord(), (Object)this.getMapRecord());
        this.sameAsReply1 = builder2.withIsEtr(true).withIsProbe(false).withIsSecurity(true).withNonce(1L).withMapRecords((List)records2).build();
        DefaultLispMapReply.DefaultReplyBuilder builder3 = new DefaultLispMapReply.DefaultReplyBuilder();
        this.reply2 = builder3.withIsEtr(false).withIsProbe(true).withIsSecurity(false).withNonce(2L).build();
    }

    private LispMapRecord getMapRecord() {
        DefaultLispMapRecord.DefaultMapRecordBuilder builder1 = new DefaultLispMapRecord.DefaultMapRecordBuilder();
        LispIpv4Address ipv4Locator1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        return builder1.withRecordTtl(100).withAuthoritative(true).withMapVersionNumber((short)1).withMaskLength((byte)1).withAction(LispMapReplyAction.NativelyForward).withEidPrefixAfi((LispAfiAddress)ipv4Locator1).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.reply1, this.sameAsReply1}).addEqualityGroup(new Object[]{this.reply2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispMapReply reply = (DefaultLispMapReply)this.reply1;
        MatcherAssert.assertThat((Object)reply.isEtr(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)reply.isProbe(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)reply.isSecurity(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)reply.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)reply.getRecordCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispMapReply.ReplyWriter writer = new DefaultLispMapReply.ReplyWriter();
        writer.writeTo(byteBuf, this.reply1);
        DefaultLispMapReply.ReplyReader reader = new DefaultLispMapReply.ReplyReader();
        LispMapReply deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.reply1, deserialized}).testEquals();
    }
}

