/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRequest;
import org.onosproject.lisp.msg.protocols.LispEidRecord;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public final class DefaultLispMapRequestTest {
    private LispMapRequest request1;
    private LispMapRequest sameAsRequest1;
    private LispMapRequest request2;

    @Before
    public void setup() {
        DefaultLispMapRequest.DefaultRequestBuilder builder1 = new DefaultLispMapRequest.DefaultRequestBuilder();
        LispIpv4Address ipv4Eid1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address ipv4Rloc1 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.1.1"));
        LispIpv4Address ipv4Rloc2 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.1.2"));
        ImmutableList rlocs1 = ImmutableList.of((Object)ipv4Rloc1, (Object)ipv4Rloc2);
        ImmutableList records1 = ImmutableList.of((Object)this.getEidRecord(), (Object)this.getEidRecord());
        this.request1 = builder1.withIsAuthoritative(true).withIsMapDataPresent(true).withIsPitr(false).withIsProbe(false).withIsSmr(true).withIsSmrInvoked(false).withSourceEid((LispAfiAddress)ipv4Eid1).withItrRlocs((List)rlocs1).withEidRecords((List)records1).withNonce(1L).build();
        DefaultLispMapRequest.DefaultRequestBuilder builder2 = new DefaultLispMapRequest.DefaultRequestBuilder();
        ImmutableList records2 = ImmutableList.of((Object)this.getEidRecord(), (Object)this.getEidRecord());
        this.sameAsRequest1 = builder2.withIsAuthoritative(true).withIsMapDataPresent(true).withIsPitr(false).withIsProbe(false).withIsSmr(true).withIsSmrInvoked(false).withSourceEid((LispAfiAddress)ipv4Eid1).withItrRlocs((List)rlocs1).withEidRecords((List)records2).withNonce(1L).build();
        DefaultLispMapRequest.DefaultRequestBuilder builder3 = new DefaultLispMapRequest.DefaultRequestBuilder();
        LispIpv4Address ipv4Eid2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        LispIpv4Address ipv4Rloc3 = new LispIpv4Address(IpAddress.valueOf((String)"20.1.1.1"));
        LispIpv4Address ipv4Rloc4 = new LispIpv4Address(IpAddress.valueOf((String)"20.1.1.2"));
        ImmutableList rlocs2 = ImmutableList.of((Object)ipv4Rloc3, (Object)ipv4Rloc4);
        this.request2 = builder3.withIsAuthoritative(false).withIsMapDataPresent(false).withIsPitr(true).withIsProbe(true).withIsSmr(false).withIsSmrInvoked(true).withSourceEid((LispAfiAddress)ipv4Eid2).withItrRlocs((List)rlocs2).withNonce(2L).build();
    }

    private LispEidRecord getEidRecord() {
        LispIpv4Address eid = new LispIpv4Address(IpAddress.valueOf((String)"20.1.1.1"));
        return new LispEidRecord(24, (LispAfiAddress)eid);
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.request1, this.sameAsRequest1}).addEqualityGroup(new Object[]{this.request2}).testEquals();
    }

    @Test
    public void testConstruction() {
        DefaultLispMapRequest request = (DefaultLispMapRequest)this.request1;
        MatcherAssert.assertThat((Object)request.isAuthoritative(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)request.isMapDataPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)request.isPitr(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.isProbe(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.isSmr(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)request.isSmrInvoked(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)request.getNonce(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((Object)request.getRecordCount(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testSerialization() throws LispReaderException, LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        DefaultLispMapRequest.RequestWriter writer = new DefaultLispMapRequest.RequestWriter();
        writer.writeTo(byteBuf, this.request1);
        DefaultLispMapRequest.RequestReader reader = new DefaultLispMapRequest.RequestReader();
        LispMapRequest deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.request1, deserialized}).testEquals();
    }
}

