/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispAppDataLcafAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public class LispAppDataLcafAddressTest {
    private LispAppDataLcafAddress address1;
    private LispAppDataLcafAddress sameAsAddress1;
    private LispAppDataLcafAddress address2;

    @Before
    public void setup() {
        LispAppDataLcafAddress.AppDataAddressBuilder builder1 = new LispAppDataLcafAddress.AppDataAddressBuilder();
        LispIpv4Address ipv4Address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.address1 = builder1.withProtocol((byte)1).withIpTos(10).withLocalPortLow((short)1).withLocalPortHigh((short)255).withRemotePortLow((short)2).withRemotePortHigh((short)254).withAddress((LispAfiAddress)ipv4Address1).build();
        LispAppDataLcafAddress.AppDataAddressBuilder builder2 = new LispAppDataLcafAddress.AppDataAddressBuilder();
        this.sameAsAddress1 = builder2.withProtocol((byte)1).withIpTos(10).withLocalPortLow((short)1).withLocalPortHigh((short)255).withRemotePortLow((short)2).withRemotePortHigh((short)254).withAddress((LispAfiAddress)ipv4Address1).build();
        LispAppDataLcafAddress.AppDataAddressBuilder builder3 = new LispAppDataLcafAddress.AppDataAddressBuilder();
        LispIpv4Address ipv4Address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        this.address2 = builder3.withProtocol((byte)2).withIpTos(20).withLocalPortLow((short)1).withLocalPortHigh((short)255).withRemotePortLow((short)2).withRemotePortHigh((short)254).withAddress((LispAfiAddress)ipv4Address2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispAppDataLcafAddress appDataLcafAddress = this.address1;
        LispIpv4Address ipv4Address = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getProtocol(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getIpTos(), (Matcher)Matchers.is((Object)10));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getLocalPortLow(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getLocalPortHigh(), (Matcher)Matchers.is((Object)255));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getRemotePortLow(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getRemotePortHigh(), (Matcher)Matchers.is((Object)254));
        MatcherAssert.assertThat((Object)appDataLcafAddress.getAddress(), (Matcher)Matchers.is((Object)ipv4Address));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispAppDataLcafAddress.AppDataLcafAddressWriter writer = new LispAppDataLcafAddress.AppDataLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispAppDataLcafAddress.AppDataLcafAddressReader reader = new LispAppDataLcafAddress.AppDataLcafAddressReader();
        LispAppDataLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

