/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispDistinguishedNameAddress;

public class LispDistinguishedNameAddressTest {
    private LispDistinguishedNameAddress address1;
    private LispDistinguishedNameAddress sameAsAddress1;
    private LispDistinguishedNameAddress address2;

    @Before
    public void setup() {
        this.address1 = new LispDistinguishedNameAddress("distAddress1");
        this.sameAsAddress1 = new LispDistinguishedNameAddress("distAddress1");
        this.address2 = new LispDistinguishedNameAddress("distAddress2");
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispDistinguishedNameAddress distinguishedNameAddress = this.address1;
        MatcherAssert.assertThat((Object)distinguishedNameAddress.getDistinguishedName(), (Matcher)Matchers.is((Object)"distAddress1"));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        LispDistinguishedNameAddress.DistinguishedNameAddressWriter writer = new LispDistinguishedNameAddress.DistinguishedNameAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispDistinguishedNameAddress.DistinguishedNameAddressReader reader = new LispDistinguishedNameAddress.DistinguishedNameAddressReader();
        LispDistinguishedNameAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

