/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispIpv4Address;

public class LispIpv4AddressTest {
    private LispIpv4Address address1;
    private LispIpv4Address sameAsAddress1;
    private LispIpv4Address address2;

    @Before
    public void setup() {
        this.address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.sameAsAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispIpv4Address ipv4Address = this.address1;
        MatcherAssert.assertThat((Object)ipv4Address.getAddress(), (Matcher)Matchers.is((Object)IpAddress.valueOf((String)"192.168.1.1")));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        LispIpv4Address.Ipv4AddressWriter writer = new LispIpv4Address.Ipv4AddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispIpv4Address.Ipv4AddressReader reader = new LispIpv4Address.Ipv4AddressReader();
        LispIpv4Address deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

