/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispIpv6Address;

public class LispIpv6AddressTest {
    private LispIpv6Address address1;
    private LispIpv6Address sameAsAddress1;
    private LispIpv6Address address2;

    @Before
    public void setup() {
        this.address1 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885"));
        this.sameAsAddress1 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885"));
        this.address2 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8886"));
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispIpv6Address ipv6Address = this.address1;
        MatcherAssert.assertThat((Object)ipv6Address.getAddress(), (Matcher)Matchers.is((Object)IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885")));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        LispIpv6Address.Ipv6AddressWriter writer = new LispIpv6Address.Ipv6AddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispIpv6Address.Ipv6AddressReader reader = new LispIpv6Address.Ipv6AddressReader();
        LispIpv6Address deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

