/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.collect.Lists;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispListLcafAddress;

public class LispListLcafAddressTest {
    private LispListLcafAddress address1;
    private LispListLcafAddress sameAsAddress1;
    private LispListLcafAddress address2;

    @Before
    public void setup() {
        LispIpv4Address ipv4Address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv6Address ipv6Address1 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885"));
        ArrayList afiAddresses1 = Lists.newArrayList();
        afiAddresses1.add(ipv4Address1);
        afiAddresses1.add(ipv6Address1);
        this.address1 = new LispListLcafAddress((List)afiAddresses1);
        this.sameAsAddress1 = new LispListLcafAddress((List)afiAddresses1);
        LispIpv4Address ipv4Address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        LispIpv6Address ipv6Address2 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8886"));
        ArrayList afiAddresses2 = Lists.newArrayList();
        afiAddresses2.add(ipv4Address2);
        afiAddresses2.add(ipv6Address2);
        this.address2 = new LispListLcafAddress((List)afiAddresses2);
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispListLcafAddress listLcafAddress = this.address1;
        LispIpv4Address ipv4Address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv6Address ipv6Address1 = new LispIpv6Address(IpAddress.valueOf((String)"1111:2222:3333:4444:5555:6666:7777:8885"));
        ArrayList afiAddresses1 = Lists.newArrayList();
        afiAddresses1.add(ipv4Address1);
        afiAddresses1.add(ipv6Address1);
        MatcherAssert.assertThat((Object)listLcafAddress.getAddresses(), (Matcher)Matchers.is((Object)afiAddresses1));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispListLcafAddress.ListLcafAddressWriter writer = new LispListLcafAddress.ListLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispListLcafAddress.ListLcafAddressReader reader = new LispListLcafAddress.ListLcafAddressReader();
        LispListLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

