/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.MacAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispMacAddress;

public class LispMacAddressTest {
    private LispMacAddress address1;
    private LispMacAddress sameAsAddress1;
    private LispMacAddress address2;

    @Before
    public void setup() {
        this.address1 = new LispMacAddress(MacAddress.valueOf((String)"00:00:00:00:00:01"));
        this.sameAsAddress1 = new LispMacAddress(MacAddress.valueOf((String)"00:00:00:00:00:01"));
        this.address2 = new LispMacAddress(MacAddress.valueOf((String)"00:00:00:00:00:02"));
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispMacAddress macAddress = this.address1;
        MatcherAssert.assertThat((Object)macAddress.getAddress(), (Matcher)Matchers.is((Object)MacAddress.valueOf((String)"00:00:00:00:00:01")));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError {
        ByteBuf byteBuf = Unpooled.buffer();
        LispMacAddress.MacAddressWriter writer = new LispMacAddress.MacAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispMacAddress.MacAddressReader reader = new LispMacAddress.MacAddressReader();
        LispMacAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

