/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispNatLcafAddress;

public class LispNatLcafAddressTest {
    private LispNatLcafAddress address1;
    private LispNatLcafAddress sameAsAddress1;
    private LispNatLcafAddress address2;

    @Before
    public void setup() {
        LispNatLcafAddress.NatAddressBuilder builder1 = new LispNatLcafAddress.NatAddressBuilder();
        short msUdpPortNumber1 = 80;
        short etrUdpPortNumber1 = 100;
        LispIpv4Address globalEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address msRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        LispIpv4Address privateEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.3"));
        LispIpv4Address rtrRloc11 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.1.1"));
        LispIpv4Address rtrRloc12 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.1.2"));
        ImmutableList rtrRlocs1 = ImmutableList.of((Object)rtrRloc11, (Object)rtrRloc12);
        this.address1 = ((LispNatLcafAddress.NatAddressBuilder)builder1.withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber1).withEtrUdpPortNumber(etrUdpPortNumber1).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress1).withMsRlocAddress((LispAfiAddress)msRlocAddress1).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress1).withRtrRlocAddresses((List)rtrRlocs1).build();
        LispNatLcafAddress.NatAddressBuilder builder2 = new LispNatLcafAddress.NatAddressBuilder();
        this.sameAsAddress1 = ((LispNatLcafAddress.NatAddressBuilder)builder2.withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber1).withEtrUdpPortNumber(etrUdpPortNumber1).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress1).withMsRlocAddress((LispAfiAddress)msRlocAddress1).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress1).withRtrRlocAddresses((List)rtrRlocs1).build();
        LispNatLcafAddress.NatAddressBuilder builder3 = new LispNatLcafAddress.NatAddressBuilder();
        short msUdpPortNumber2 = 81;
        short etrUdpPortNumber2 = 101;
        LispIpv4Address globalEtrRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        LispIpv4Address msRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.2"));
        LispIpv4Address privateEtrRlocAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.3"));
        LispIpv4Address rtrRloc21 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.2.1"));
        LispIpv4Address rtrRloc22 = new LispIpv4Address(IpAddress.valueOf((String)"10.1.2.2"));
        ImmutableList rtrRlocs2 = ImmutableList.of((Object)rtrRloc21, (Object)rtrRloc22);
        this.address2 = ((LispNatLcafAddress.NatAddressBuilder)builder3.withLength((short)0)).withMsUdpPortNumber(msUdpPortNumber2).withEtrUdpPortNumber(etrUdpPortNumber2).withGlobalEtrRlocAddress((LispAfiAddress)globalEtrRlocAddress2).withMsRlocAddress((LispAfiAddress)msRlocAddress2).withPrivateEtrRlocAddress((LispAfiAddress)privateEtrRlocAddress2).withRtrRlocAddresses((List)rtrRlocs2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispNatLcafAddress natLcafAddress = this.address1;
        LispIpv4Address globalEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address msRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        LispIpv4Address privateEtrRlocAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.3"));
        MatcherAssert.assertThat((Object)natLcafAddress.getLength(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)natLcafAddress.getMsUdpPortNumber(), (Matcher)Matchers.is((Object)80));
        MatcherAssert.assertThat((Object)natLcafAddress.getEtrUdpPortNumber(), (Matcher)Matchers.is((Object)100));
        MatcherAssert.assertThat((Object)natLcafAddress.getGlobalEtrRlocAddress(), (Matcher)Matchers.is((Object)globalEtrRlocAddress1));
        MatcherAssert.assertThat((Object)natLcafAddress.getMsRlocAddress(), (Matcher)Matchers.is((Object)msRlocAddress1));
        MatcherAssert.assertThat((Object)natLcafAddress.getPrivateEtrRlocAddress(), (Matcher)Matchers.is((Object)privateEtrRlocAddress1));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispNatLcafAddress.NatLcafAddressWriter writer = new LispNatLcafAddress.NatLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispNatLcafAddress.NatLcafAddressReader reader = new LispNatLcafAddress.NatLcafAddressReader();
        LispNatLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

