/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispSegmentLcafAddress;

public class LispSegmentLcafAddressTest {
    private LispSegmentLcafAddress address1;
    private LispSegmentLcafAddress sameAsAddress1;
    private LispSegmentLcafAddress address2;

    @Before
    public void setup() {
        LispSegmentLcafAddress.SegmentAddressBuilder builder1 = new LispSegmentLcafAddress.SegmentAddressBuilder();
        LispIpv4Address ipv4Address1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        this.address1 = builder1.withIdMaskLength((byte)1).withInstanceId(1).withAddress((LispAfiAddress)ipv4Address1).build();
        LispSegmentLcafAddress.SegmentAddressBuilder builder2 = new LispSegmentLcafAddress.SegmentAddressBuilder();
        this.sameAsAddress1 = builder2.withIdMaskLength((byte)1).withInstanceId(1).withAddress((LispAfiAddress)ipv4Address1).build();
        LispSegmentLcafAddress.SegmentAddressBuilder builder3 = new LispSegmentLcafAddress.SegmentAddressBuilder();
        LispIpv4Address ipv4Address2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        this.address2 = builder3.withIdMaskLength((byte)2).withInstanceId(2).withAddress((LispAfiAddress)ipv4Address2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispSegmentLcafAddress segmentLcafAddress = this.address1;
        LispIpv4Address ipv4Address = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        MatcherAssert.assertThat((Object)segmentLcafAddress.getIdMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentLcafAddress.getInstanceId(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)segmentLcafAddress.getAddress(), (Matcher)Matchers.is((Object)ipv4Address));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispSegmentLcafAddress.SegmentLcafAddressWriter writer = new LispSegmentLcafAddress.SegmentLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispSegmentLcafAddress.SegmentLcafAddressReader reader = new LispSegmentLcafAddress.SegmentLcafAddressReader();
        LispSegmentLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

