/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispSourceDestLcafAddress;

public class LispSourceDestLcafAddressTest {
    private LispSourceDestLcafAddress address1;
    private LispSourceDestLcafAddress sameAsAddress1;
    private LispSourceDestLcafAddress address2;

    @Before
    public void setup() {
        LispSourceDestLcafAddress.SourceDestAddressBuilder builder1 = new LispSourceDestLcafAddress.SourceDestAddressBuilder();
        LispIpv4Address srcAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address dstAddress1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        this.address1 = builder1.withReserved((short)1).withSrcMaskLength((byte)1).withDstMaskLength((byte)1).withSrcPrefix((LispAfiAddress)srcAddress1).withDstPrefix((LispAfiAddress)dstAddress1).build();
        LispSourceDestLcafAddress.SourceDestAddressBuilder builder2 = new LispSourceDestLcafAddress.SourceDestAddressBuilder();
        this.sameAsAddress1 = builder2.withReserved((short)1).withSrcMaskLength((byte)1).withDstMaskLength((byte)1).withSrcPrefix((LispAfiAddress)srcAddress1).withDstPrefix((LispAfiAddress)dstAddress1).build();
        LispSourceDestLcafAddress.SourceDestAddressBuilder builder3 = new LispSourceDestLcafAddress.SourceDestAddressBuilder();
        LispIpv4Address srcAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        LispIpv4Address dstAddress2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.2"));
        this.address2 = builder3.withReserved((short)2).withSrcMaskLength((byte)2).withDstMaskLength((byte)2).withSrcPrefix((LispAfiAddress)srcAddress2).withDstPrefix((LispAfiAddress)dstAddress2).build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispSourceDestLcafAddress sourceDestLcafAddress = this.address1;
        LispIpv4Address srcAddress = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address dstAddress = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        MatcherAssert.assertThat((Object)sourceDestLcafAddress.getReserved(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sourceDestLcafAddress.getSrcMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sourceDestLcafAddress.getDstMaskLength(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)sourceDestLcafAddress.getSrcPrefix(), (Matcher)Matchers.is((Object)srcAddress));
        MatcherAssert.assertThat((Object)sourceDestLcafAddress.getDstPrefix(), (Matcher)Matchers.is((Object)dstAddress));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispSourceDestLcafAddress.SourceDestLcafAddressWriter writer = new LispSourceDestLcafAddress.SourceDestLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispSourceDestLcafAddress.SourceDestLcafAddressReader reader = new LispSourceDestLcafAddress.SourceDestLcafAddressReader();
        LispSourceDestLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

