/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispTeLcafAddress;
import org.onosproject.lisp.msg.types.LispTeRecord;

public class LispTeLcafAddressTest {
    private LispTeLcafAddress address1;
    private LispTeLcafAddress sameAsAddress1;
    private LispTeLcafAddress address2;

    @Before
    public void setup() {
        LispTeLcafAddress.TeAddressBuilder builder1 = new LispTeLcafAddress.TeAddressBuilder();
        LispTeRecord.TeRecordBuilder recordBuilder1 = new LispTeRecord.TeRecordBuilder();
        LispIpv4Address rtrRloc1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        recordBuilder1.withIsLookup(false);
        recordBuilder1.withIsRlocProbe(false);
        recordBuilder1.withIsStrict(false);
        recordBuilder1.withRtrRlocAddress((LispAfiAddress)rtrRloc1);
        LispTeRecord record1 = recordBuilder1.build();
        LispTeRecord.TeRecordBuilder recordBuilder2 = new LispTeRecord.TeRecordBuilder();
        LispIpv4Address rtrRloc2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        recordBuilder2.withIsLookup(false);
        recordBuilder2.withIsRlocProbe(true);
        recordBuilder2.withIsStrict(false);
        recordBuilder2.withRtrRlocAddress((LispAfiAddress)rtrRloc2);
        LispTeRecord record2 = recordBuilder2.build();
        builder1.withTeRecords((List)ImmutableList.of((Object)record1, (Object)record2));
        this.address1 = builder1.build();
        LispTeLcafAddress.TeAddressBuilder builder2 = new LispTeLcafAddress.TeAddressBuilder();
        LispTeRecord.TeRecordBuilder recordBuilder3 = new LispTeRecord.TeRecordBuilder();
        recordBuilder3.withIsLookup(false);
        recordBuilder3.withIsRlocProbe(false);
        recordBuilder3.withIsStrict(false);
        recordBuilder3.withRtrRlocAddress((LispAfiAddress)rtrRloc1);
        LispTeRecord record3 = recordBuilder3.build();
        LispTeRecord.TeRecordBuilder recordBuilder4 = new LispTeRecord.TeRecordBuilder();
        recordBuilder4.withIsLookup(false);
        recordBuilder4.withIsRlocProbe(true);
        recordBuilder4.withIsStrict(false);
        recordBuilder4.withRtrRlocAddress((LispAfiAddress)rtrRloc2);
        LispTeRecord record4 = recordBuilder4.build();
        builder2.withTeRecords((List)ImmutableList.of((Object)record3, (Object)record4));
        this.sameAsAddress1 = builder2.build();
        LispTeLcafAddress.TeAddressBuilder builder3 = new LispTeLcafAddress.TeAddressBuilder();
        LispTeRecord.TeRecordBuilder recordBuilder5 = new LispTeRecord.TeRecordBuilder();
        LispIpv4Address rtrRloc3 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.1"));
        recordBuilder5.withIsLookup(true);
        recordBuilder5.withIsRlocProbe(false);
        recordBuilder5.withIsStrict(true);
        recordBuilder5.withRtrRlocAddress((LispAfiAddress)rtrRloc3);
        LispTeRecord record5 = recordBuilder5.build();
        LispTeRecord.TeRecordBuilder recordBuilder6 = new LispTeRecord.TeRecordBuilder();
        LispIpv4Address rtrRloc4 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.2.2"));
        recordBuilder6.withIsLookup(true);
        recordBuilder6.withIsRlocProbe(true);
        recordBuilder6.withIsStrict(true);
        recordBuilder6.withRtrRlocAddress((LispAfiAddress)rtrRloc4);
        LispTeRecord record6 = recordBuilder6.build();
        builder3.withTeRecords((List)ImmutableList.of((Object)record5, (Object)record6));
        this.address2 = builder3.build();
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, this.sameAsAddress1}).addEqualityGroup(new Object[]{this.address2}).testEquals();
    }

    @Test
    public void testConstruction() {
        LispTeLcafAddress teLcafAddress = this.address1;
        LispIpv4Address rtrRloc1 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.1"));
        LispIpv4Address rtrRloc2 = new LispIpv4Address(IpAddress.valueOf((String)"192.168.1.2"));
        MatcherAssert.assertThat((String)"lookup flag value in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(0)).isLookup(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"RLOC probe flag value in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(0)).isRlocProbe(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"strict flag value in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(0)).isStrict(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"RTR RLOC address in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(0)).getRtrRlocAddress(), (Matcher)Matchers.is((Object)rtrRloc1));
        MatcherAssert.assertThat((String)"lookup flag value in TeRecord in not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(1)).isLookup(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"RLOC probe flag value in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(1)).isRlocProbe(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"strict flag value in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(1)).isStrict(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"RTR RLOC address in TeRecord is not correct", (Object)((LispTeRecord)teLcafAddress.getTeRecords().get(1)).getRtrRlocAddress(), (Matcher)Matchers.is((Object)rtrRloc2));
    }

    @Test
    public void testSerialization() throws LispWriterException, LispParseError, LispReaderException {
        ByteBuf byteBuf = Unpooled.buffer();
        LispTeLcafAddress.TeLcafAddressWriter writer = new LispTeLcafAddress.TeLcafAddressWriter();
        writer.writeTo(byteBuf, this.address1);
        LispTeLcafAddress.TeLcafAddressReader reader = new LispTeLcafAddress.TeLcafAddressReader();
        LispTeLcafAddress deserialized = reader.readFrom(byteBuf);
        new EqualsTester().addEqualityGroup(new Object[]{this.address1, deserialized}).testEquals();
    }
}

