/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.onlab.packet.DeserializationException;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.DefaultLispGenericLocator;
import org.onosproject.lisp.msg.protocols.LispGenericLocator;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispReferral;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public final class DefaultLispReferral
extends DefaultLispGenericLocator
implements LispReferral {
    static final ReferralWriter WRITER = new ReferralWriter();

    private DefaultLispReferral(byte priority, byte weight, byte multicastPriority, byte multicastWeight, boolean localLocator, boolean rlocProbed, boolean routed, LispAfiAddress locatorAfi) {
        super(priority, weight, multicastPriority, multicastWeight, localLocator, rlocProbed, routed, locatorAfi);
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
        WRITER.writeTo(byteBuf, this);
    }

    public static final class ReferralWriter
    implements LispMessageWriter<LispReferral> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispReferral message) throws LispWriterException {
            DefaultLispGenericLocator.serialize(byteBuf, message);
        }
    }

    public static final class ReferralReader
    implements LispMessageReader<LispReferral> {
        @Override
        public LispReferral readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException, DeserializationException {
            LispGenericLocator gl = DefaultLispGenericLocator.deserialize(byteBuf);
            return ((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)((LispReferral.ReferralBuilder)new DefaultReferralBuilder().withPriority(gl.getPriority())).withWeight(gl.getWeight())).withMulticastPriority(gl.getMulticastPriority())).withMulticastWeight(gl.getMulticastWeight())).withLocalLocator(gl.isLocalLocator())).withRouted(gl.isRouted())).withLocatorAfi(gl.getLocatorAfi())).build();
        }
    }

    public static final class DefaultReferralBuilder
    extends DefaultLispGenericLocator.AbstractGenericLocatorBuilder<LispReferral.ReferralBuilder>
    implements LispReferral.ReferralBuilder {
        @Override
        public LispReferral build() {
            Preconditions.checkNotNull((Object)this.locatorAfi, (Object)"Must specify a locator address");
            return new DefaultLispReferral(this.priority, this.weight, this.multicastPriority, this.multicastWeight, this.localLocator, this.rlocProbed, this.routed, this.locatorAfi);
        }
    }
}

