/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.buffer.ByteBuf;
import org.onlab.packet.DeserializationException;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispMessageWriter;
import org.onosproject.lisp.msg.protocols.LispSignature;

public final class DefaultLispSignature
implements LispSignature {
    private final int recordTtl;
    private final int sigExpiration;
    private final int sigInception;
    private final short keyTag;
    private final short sigLength;
    private final byte sigAlgorithm;
    private final int signature;

    private DefaultLispSignature(int recordTtl, int sigExpiration, int sigInception, short keyTag, short sigLength, byte sigAlgorithm, int signature) {
        this.recordTtl = recordTtl;
        this.sigExpiration = sigExpiration;
        this.sigInception = sigInception;
        this.keyTag = keyTag;
        this.sigLength = sigLength;
        this.sigAlgorithm = sigAlgorithm;
        this.signature = signature;
    }

    @Override
    public int getRecordTtl() {
        return this.recordTtl;
    }

    @Override
    public int getSigExpiration() {
        return this.sigExpiration;
    }

    @Override
    public int getSigInception() {
        return this.sigInception;
    }

    @Override
    public short getKeyTag() {
        return this.keyTag;
    }

    @Override
    public short getSigLength() {
        return this.sigLength;
    }

    @Override
    public byte getSigAlgorithm() {
        return this.sigAlgorithm;
    }

    @Override
    public int getSignature() {
        return this.signature;
    }

    @Override
    public void writeTo(ByteBuf byteBuf) throws LispWriterException {
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("record TTL", this.recordTtl).add("signature expiration", this.sigExpiration).add("signature inception", this.sigInception).add("key tag", (int)this.keyTag).add("signature length", (int)this.sigLength).add("signature algorithm", (int)this.sigAlgorithm).add("signature", this.signature).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultLispSignature that = (DefaultLispSignature)o;
        return Objects.equal((Object)this.recordTtl, (Object)that.recordTtl) && Objects.equal((Object)this.sigExpiration, (Object)that.sigExpiration) && Objects.equal((Object)this.sigInception, (Object)that.sigInception) && Objects.equal((Object)this.keyTag, (Object)that.keyTag) && Objects.equal((Object)this.sigLength, (Object)that.sigLength) && Objects.equal((Object)this.sigAlgorithm, (Object)that.sigAlgorithm) && Objects.equal((Object)this.signature, (Object)that.signature);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.recordTtl, this.sigExpiration, this.sigInception, this.keyTag, this.sigLength, this.sigAlgorithm, this.signature});
    }

    public static final class SignatureWriter
    implements LispMessageWriter<LispSignature> {
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispSignature message) throws LispWriterException {
            byteBuf.writeInt(message.getRecordTtl());
            byteBuf.writeInt(message.getSigExpiration());
            byteBuf.writeInt(message.getSigInception());
            byteBuf.writeShort((int)message.getKeyTag());
            byteBuf.writeShort((int)message.getSigLength());
            byteBuf.writeByte((int)message.getSigAlgorithm());
            byteBuf.writeByte(0);
            byteBuf.writeShort(0);
            byteBuf.writeInt(message.getSignature());
        }
    }

    public static final class SignatureReader
    implements LispMessageReader<LispSignature> {
        private static final int RESERVED_SKIP_LENGTH = 3;

        @Override
        public LispSignature readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException, DeserializationException {
            int recordTtl = byteBuf.readInt();
            int sigExpiration = byteBuf.readInt();
            int sigInception = byteBuf.readInt();
            short keyTag = byteBuf.readShort();
            short sigLength = byteBuf.readShort();
            byte sigAlgorithm = byteBuf.readByte();
            byteBuf.skipBytes(3);
            int signature = byteBuf.readInt();
            return new DefaultSignatureBuilder().withRecordTtl(recordTtl).withSigExpiration(sigExpiration).withSigInception(sigInception).withKeyTag(keyTag).withSigLength(sigLength).withSigAlgorithm(sigAlgorithm).withSignature(signature).build();
        }
    }

    public static final class DefaultSignatureBuilder
    implements LispSignature.SignatureBuilder {
        private int recordTtl;
        private int sigExpiration;
        private int sigInception;
        private short keyTag;
        private short sigLength;
        private byte sigAlgorithm;
        private int signature;

        @Override
        public LispSignature.SignatureBuilder withRecordTtl(int recordTtl) {
            this.recordTtl = recordTtl;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withSigExpiration(int sigExpiration) {
            this.sigExpiration = sigExpiration;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withSigInception(int sigInception) {
            this.sigInception = sigInception;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withKeyTag(short keyTag) {
            this.keyTag = keyTag;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withSigLength(short sigLength) {
            this.sigLength = sigLength;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withSigAlgorithm(byte sigAlgorithm) {
            this.sigAlgorithm = sigAlgorithm;
            return this;
        }

        @Override
        public LispSignature.SignatureBuilder withSignature(int signature) {
            this.signature = signature;
            return this;
        }

        @Override
        public LispSignature build() {
            return new DefaultLispSignature(this.recordTtl, this.sigExpiration, this.sigInception, this.keyTag, this.sigLength, this.sigAlgorithm, this.signature);
        }
    }
}

