/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;

public class LispAsAddress
extends LispAfiAddress {
    private final int asNum;

    public LispAsAddress(int num) {
        super(AddressFamilyIdentifierEnum.AS);
        this.asNum = num;
    }

    public int getASNum() {
        return this.asNum;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.asNum);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LispAsAddress other = (LispAsAddress)obj;
        return this.asNum == other.asNum;
    }

    public String toString() {
        return String.valueOf(this.asNum);
    }

    public static class AsAddressWriter
    implements LispAddressWriter<LispAsAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispAsAddress address) throws LispWriterException {
            throw new LispWriterException("Unimplemented method");
        }
    }

    public static class AsAddressReader
    implements LispAddressReader<LispAsAddress> {
        @Override
        public LispAsAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            throw new LispReaderException("Unimplemented method");
        }
    }
}

