/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onlab.packet.IpAddress;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispIpAddress;

public class LispIpv4Address
extends LispIpAddress {
    public LispIpv4Address(IpAddress address) {
        super(address, AddressFamilyIdentifierEnum.IP4);
        Preconditions.checkArgument((boolean)address.isIp4());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispIpv4Address) {
            LispIpv4Address other = (LispIpv4Address)obj;
            return Objects.equals(this.address, other.address) && Objects.equals((Object)this.getAfi(), (Object)other.getAfi());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.getAfi()});
    }

    public static class Ipv4AddressWriter
    implements LispAddressWriter<LispIpv4Address> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispIpv4Address address) throws LispWriterException {
            byte[] ipByte = address.getAddress().getIp4Address().toOctets();
            byteBuf.writeBytes(ipByte);
        }
    }

    public static class Ipv4AddressReader
    implements LispAddressReader<LispIpv4Address> {
        private static final int SIZE_OF_IPV4_ADDRESS = 4;

        @Override
        public LispIpv4Address readFrom(ByteBuf byteBuf) throws LispParseError {
            byte[] ipByte = new byte[4];
            byteBuf.readBytes(ipByte);
            IpAddress ipAddress = IpAddress.valueOf((IpAddress.Version)IpAddress.Version.INET, (byte[])ipByte);
            return new LispIpv4Address(ipAddress);
        }
    }
}

