/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispMulticastLcafAddress
extends LispLcafAddress {
    private final int instanceId;
    private final byte srcMaskLength;
    private final byte grpMaskLength;
    private final LispAfiAddress srcAddress;
    private final LispAfiAddress grpAddress;

    private LispMulticastLcafAddress(int instanceId, byte srcMaskLength, byte grpMaskLength, LispAfiAddress srcAddress, LispAfiAddress grpAddress) {
        super(LispCanonicalAddressFormatEnum.MULTICAST);
        this.instanceId = instanceId;
        this.srcMaskLength = srcMaskLength;
        this.grpMaskLength = grpMaskLength;
        this.srcAddress = srcAddress;
        this.grpAddress = grpAddress;
    }

    public int getInstanceId() {
        return this.instanceId;
    }

    public byte getSrcMaskLength() {
        return this.srcMaskLength;
    }

    public byte getGrpMaskLength() {
        return this.grpMaskLength;
    }

    public LispAfiAddress getSrcAddress() {
        return this.srcAddress;
    }

    public LispAfiAddress getGrpAddress() {
        return this.grpAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.instanceId, this.srcMaskLength, this.grpMaskLength, this.srcAddress, this.grpAddress);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispMulticastLcafAddress) {
            LispMulticastLcafAddress other = (LispMulticastLcafAddress)obj;
            return Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.srcMaskLength, other.srcMaskLength) && Objects.equals(this.grpMaskLength, other.grpMaskLength) && Objects.equals(this.srcAddress, other.srcAddress) && Objects.equals(this.grpAddress, other.grpAddress);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("instance ID", this.instanceId).add("source mask length", (int)this.srcMaskLength).add("group mask length", (int)this.grpMaskLength).add("source address", (Object)this.srcAddress).add("group address", (Object)this.grpAddress).toString();
    }

    public static class MulticastLcafAddressWriter
    implements LispAddressWriter<LispMulticastLcafAddress> {
        private static final int UNUSED_ZERO = 0;

        @Override
        public void writeTo(ByteBuf byteBuf, LispMulticastLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeInt(address.getInstanceId());
            byteBuf.writeByte(0);
            byteBuf.writeByte(0);
            byteBuf.writeByte((int)address.getSrcMaskLength());
            byteBuf.writeByte((int)address.getGrpMaskLength());
            LispAfiAddress.AfiAddressWriter srcWriter = new LispAfiAddress.AfiAddressWriter();
            srcWriter.writeTo(byteBuf, address.getSrcAddress());
            LispAfiAddress.AfiAddressWriter grpWriter = new LispAfiAddress.AfiAddressWriter();
            grpWriter.writeTo(byteBuf, address.getGrpAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class MulticastLcafAddressReader
    implements LispAddressReader<LispMulticastLcafAddress> {
        private static final int RESERVED_SKIP_LENGTH = 2;

        @Override
        public LispMulticastLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            int instanceId = (int)byteBuf.readUnsignedInt();
            byteBuf.skipBytes(2);
            byte srcMaskLength = (byte)byteBuf.readUnsignedByte();
            byte grpMaskLength = (byte)byteBuf.readUnsignedByte();
            LispAfiAddress srcAddress = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            LispAfiAddress grpAddress = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new MulticastAddressBuilder().withInstanceId(instanceId).withSrcMaskLength(srcMaskLength).withGrpMaskLength(grpMaskLength).withSrcAddress(srcAddress).withGrpAddress(grpAddress).build();
        }
    }

    public static final class MulticastAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<MulticastAddressBuilder> {
        private int instanceId;
        private byte srcMaskLength;
        private byte grpMaskLength;
        private LispAfiAddress srcAddress;
        private LispAfiAddress grpAddress;

        public MulticastAddressBuilder withInstanceId(int instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public MulticastAddressBuilder withSrcMaskLength(byte srcMaskLength) {
            this.srcMaskLength = srcMaskLength;
            return this;
        }

        public MulticastAddressBuilder withGrpMaskLength(byte grpMaskLength) {
            this.grpMaskLength = grpMaskLength;
            return this;
        }

        public MulticastAddressBuilder withSrcAddress(LispAfiAddress srcAddress) {
            this.srcAddress = srcAddress;
            return this;
        }

        public MulticastAddressBuilder withGrpAddress(LispAfiAddress grpAddress) {
            this.grpAddress = grpAddress;
            return this;
        }

        @Override
        public LispMulticastLcafAddress build() {
            Preconditions.checkNotNull((Object)this.srcAddress, (Object)"Must specify a source address");
            Preconditions.checkNotNull((Object)this.grpAddress, (Object)"Must specify a group address");
            return new LispMulticastLcafAddress(this.instanceId, this.srcMaskLength, this.grpMaskLength, this.srcAddress, this.grpAddress);
        }
    }
}

