/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispNatLcafAddress
extends LispLcafAddress {
    private final short msUdpPortNumber;
    private final short etrUdpPortNumber;
    private final LispAfiAddress globalEtrRlocAddress;
    private final LispAfiAddress msRlocAddress;
    private final LispAfiAddress privateEtrRlocAddress;
    private final List<LispAfiAddress> rtrRlocAddresses;

    private LispNatLcafAddress(byte reserved2, short length, short msUdpPortNumber, short etrUdpPortNumber, LispAfiAddress globalEtrRlocAddress, LispAfiAddress msRlocAddress, LispAfiAddress privateEtrRlocAddress, List<LispAfiAddress> rtrRlocAddresses) {
        super(LispCanonicalAddressFormatEnum.NAT, reserved2, length);
        this.msUdpPortNumber = msUdpPortNumber;
        this.etrUdpPortNumber = etrUdpPortNumber;
        this.globalEtrRlocAddress = globalEtrRlocAddress;
        this.msRlocAddress = msRlocAddress;
        this.privateEtrRlocAddress = privateEtrRlocAddress;
        this.rtrRlocAddresses = ImmutableList.copyOf(rtrRlocAddresses);
    }

    public short getMsUdpPortNumber() {
        return this.msUdpPortNumber;
    }

    public short getEtrUdpPortNumber() {
        return this.etrUdpPortNumber;
    }

    public LispAfiAddress getGlobalEtrRlocAddress() {
        return this.globalEtrRlocAddress;
    }

    public LispAfiAddress getMsRlocAddress() {
        return this.msRlocAddress;
    }

    public LispAfiAddress getPrivateEtrRlocAddress() {
        return this.privateEtrRlocAddress;
    }

    public List<LispAfiAddress> getRtrRlocAddresses() {
        return ImmutableList.copyOf(this.rtrRlocAddresses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.msUdpPortNumber, this.etrUdpPortNumber, this.globalEtrRlocAddress, this.msRlocAddress, this.privateEtrRlocAddress);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispNatLcafAddress) {
            LispNatLcafAddress other = (LispNatLcafAddress)obj;
            return Objects.equals(this.msUdpPortNumber, other.msUdpPortNumber) && Objects.equals(this.etrUdpPortNumber, other.etrUdpPortNumber) && Objects.equals(this.globalEtrRlocAddress, other.globalEtrRlocAddress) && Objects.equals(this.msRlocAddress, other.msRlocAddress) && Objects.equals(this.privateEtrRlocAddress, other.privateEtrRlocAddress) && Objects.equals(this.rtrRlocAddresses, other.rtrRlocAddresses);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("Map Server UDP port number", (int)this.msUdpPortNumber).add("ETR UDP port number", (int)this.etrUdpPortNumber).add("global ETR RLOC address", (Object)this.globalEtrRlocAddress).add("Map Server RLOC address", (Object)this.msRlocAddress).add("private ETR RLOC address", (Object)this.privateEtrRlocAddress).add("RTR RLOC addresses", this.rtrRlocAddresses).toString();
    }

    public static class NatLcafAddressWriter
    implements LispAddressWriter<LispNatLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispNatLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeShort((int)address.getMsUdpPortNumber());
            byteBuf.writeShort((int)address.getEtrUdpPortNumber());
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, address.getGlobalEtrRlocAddress());
            writer.writeTo(byteBuf, address.getMsRlocAddress());
            writer.writeTo(byteBuf, address.getPrivateEtrRlocAddress());
            List<LispAfiAddress> rtrRlocAddresses = address.getRtrRlocAddresses();
            for (LispAfiAddress rtrRlocAddress : rtrRlocAddresses) {
                writer.writeTo(byteBuf, rtrRlocAddress);
            }
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class NatLcafAddressReader
    implements LispAddressReader<LispNatLcafAddress> {
        @Override
        public LispNatLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress lcafAddress = LispLcafAddress.deserializeCommon(byteBuf);
            short msUdpPortNumber = (short)byteBuf.readUnsignedShort();
            short etrUdpPortNumber = (short)byteBuf.readUnsignedShort();
            LispAfiAddress globalEtrRlocAddress = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            LispAfiAddress msRlocAddress = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            LispAfiAddress privateEtrRlocAddress = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            ArrayList rtrRlocAddresses = Lists.newArrayList();
            while (byteBuf.readerIndex() - 8 < lcafAddress.getLength()) {
                rtrRlocAddresses.add(new LispAfiAddress.AfiAddressReader().readFrom(byteBuf));
            }
            return new NatAddressBuilder().withMsUdpPortNumber(msUdpPortNumber).withEtrUdpPortNumber(etrUdpPortNumber).withGlobalEtrRlocAddress(globalEtrRlocAddress).withMsRlocAddress(msRlocAddress).withPrivateEtrRlocAddress(privateEtrRlocAddress).withRtrRlocAddresses(rtrRlocAddresses).build();
        }
    }

    public static final class NatAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<NatAddressBuilder> {
        private short msUdpPortNumber;
        private short etrUdpPortNumber;
        private LispAfiAddress globalEtrRlocAddress;
        private LispAfiAddress msRlocAddress;
        private LispAfiAddress privateEtrRlocAddress;
        private List<LispAfiAddress> rtrRlocAddresses = Lists.newArrayList();

        public NatAddressBuilder withMsUdpPortNumber(short msUdpPortNumber) {
            this.msUdpPortNumber = msUdpPortNumber;
            return this;
        }

        public NatAddressBuilder withEtrUdpPortNumber(short etrUdpPortNumber) {
            this.etrUdpPortNumber = etrUdpPortNumber;
            return this;
        }

        public NatAddressBuilder withGlobalEtrRlocAddress(LispAfiAddress globalEtrRlocAddress) {
            this.globalEtrRlocAddress = globalEtrRlocAddress;
            return this;
        }

        public NatAddressBuilder withMsRlocAddress(LispAfiAddress msRlocAddress) {
            this.msRlocAddress = msRlocAddress;
            return this;
        }

        public NatAddressBuilder withPrivateEtrRlocAddress(LispAfiAddress privateEtrRlocAddress) {
            this.privateEtrRlocAddress = privateEtrRlocAddress;
            return this;
        }

        public NatAddressBuilder withRtrRlocAddresses(List<LispAfiAddress> rtrRlocAddresses) {
            if (rtrRlocAddresses != null) {
                this.rtrRlocAddresses = ImmutableList.copyOf(rtrRlocAddresses);
            }
            return this;
        }

        @Override
        public LispNatLcafAddress build() {
            return new LispNatLcafAddress(this.reserved2, this.length, this.msUdpPortNumber, this.etrUdpPortNumber, this.globalEtrRlocAddress, this.msRlocAddress, this.privateEtrRlocAddress, this.rtrRlocAddresses);
        }
    }
}

