/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public final class LispNonceLcafAddress
extends LispLcafAddress {
    private final int nonce;
    private final LispAfiAddress address;

    private LispNonceLcafAddress(int nonce, LispAfiAddress address) {
        super(LispCanonicalAddressFormatEnum.NONCE);
        this.nonce = nonce;
        this.address = address;
    }

    public int getNonce() {
        return this.nonce;
    }

    public LispAfiAddress getAddress() {
        return this.address;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nonce, this.address);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispNonceLcafAddress) {
            LispNonceLcafAddress other = (LispNonceLcafAddress)obj;
            return Objects.equals(this.nonce, other.nonce) && Objects.equals(this.address, other.address);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nonce", this.nonce).add("address", (Object)this.address).toString();
    }

    public static class NonceLcafAddressWriter
    implements LispAddressWriter<LispNonceLcafAddress> {
        private static final int UNUSED_ZERO = 0;
        private static final int NONCE_SHIFT_BIT = 16;

        @Override
        public void writeTo(ByteBuf byteBuf, LispNonceLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            byteBuf.writeByte(0);
            int nonceFirst = address.getNonce() >> 16;
            byteBuf.writeShort((int)((short)nonceFirst));
            int nonceSecond = address.getNonce() - (nonceFirst << 16);
            byteBuf.writeInt(nonceSecond);
            LispAfiAddress.AfiAddressWriter writer = new LispAfiAddress.AfiAddressWriter();
            writer.writeTo(byteBuf, address.getAddress());
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class NonceLcafAddressReader
    implements LispAddressReader<LispNonceLcafAddress> {
        private static final int NONCE_SHIFT_BIT = 16;
        private static final int RESERVED_SKIP_LENGTH = 1;

        @Override
        public LispNonceLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress.deserializeCommon(byteBuf);
            byteBuf.skipBytes(1);
            int nonceFirst = byteBuf.readShort() << 16;
            int nonceSecond = byteBuf.readInt();
            int nonce = nonceFirst + nonceSecond;
            LispAfiAddress address = new LispAfiAddress.AfiAddressReader().readFrom(byteBuf);
            return new NonceAddressBuilder().withNonce(nonce).withAddress(address).build();
        }
    }

    public static final class NonceAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<NonceAddressBuilder> {
        private int nonce;
        private LispAfiAddress address;

        public NonceAddressBuilder withNonce(int nonce) {
            this.nonce = nonce;
            return this;
        }

        public NonceAddressBuilder withAddress(LispAfiAddress address) {
            this.address = address;
            return this;
        }

        @Override
        public LispNonceLcafAddress build() {
            Preconditions.checkNotNull((Object)this.address, (Object)"Must specify an address");
            return new LispNonceLcafAddress(this.nonce, this.address);
        }
    }
}

