/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types;

import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAsAddress;
import org.onosproject.lisp.msg.types.LispDistinguishedNameAddress;
import org.onosproject.lisp.msg.types.LispIpAddress;
import org.onosproject.lisp.msg.types.LispIpv4Address;
import org.onosproject.lisp.msg.types.LispIpv6Address;
import org.onosproject.lisp.msg.types.LispMacAddress;
import org.onosproject.lisp.msg.types.LispNoAddress;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;

public abstract class LispAfiAddress {
    private final AddressFamilyIdentifierEnum afi;

    protected LispAfiAddress(AddressFamilyIdentifierEnum afi) {
        this.afi = afi;
    }

    public AddressFamilyIdentifierEnum getAfi() {
        return this.afi;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.afi});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LispAfiAddress other = (LispAfiAddress)obj;
        return this.afi == other.afi;
    }

    public static class AfiAddressWriter
    implements LispAddressWriter<LispAfiAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispAfiAddress address) throws LispWriterException {
            byteBuf.writeShort((int)address.getAfi().getIanaCode());
            switch (address.getAfi()) {
                case NO_ADDRESS: {
                    new LispNoAddress.NoAddressWriter().writeTo(byteBuf, (LispNoAddress)address);
                    break;
                }
                case IP4: {
                    new LispIpAddress.IpAddressWriter().writeTo(byteBuf, (LispIpv4Address)address);
                    break;
                }
                case IP6: {
                    new LispIpAddress.IpAddressWriter().writeTo(byteBuf, (LispIpv6Address)address);
                    break;
                }
                case DISTINGUISHED_NAME: {
                    new LispDistinguishedNameAddress.DistinguishedNameAddressWriter().writeTo(byteBuf, (LispDistinguishedNameAddress)address);
                    break;
                }
                case MAC: {
                    new LispMacAddress.MacAddressWriter().writeTo(byteBuf, (LispMacAddress)address);
                    break;
                }
                case LCAF: {
                    new LispLcafAddress.LcafAddressWriter().writeTo(byteBuf, (LispLcafAddress)address);
                    break;
                }
                case AS: {
                    new LispAsAddress.AsAddressWriter().writeTo(byteBuf, (LispAsAddress)address);
                    break;
                }
            }
        }
    }

    public static class AfiAddressReader
    implements LispAddressReader<LispAfiAddress> {
        @Override
        public LispAfiAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            int index = byteBuf.readerIndex();
            short afiCode = (short)byteBuf.getUnsignedShort(index);
            if (afiCode == AddressFamilyIdentifierEnum.NO_ADDRESS.getIanaCode()) {
                byteBuf.readUnsignedShort();
                return new LispNoAddress.NoAddressReader().readFrom(byteBuf);
            }
            if (afiCode == AddressFamilyIdentifierEnum.IP4.getIanaCode() || afiCode == AddressFamilyIdentifierEnum.IP6.getIanaCode()) {
                return new LispIpAddress.IpAddressReader().readFrom(byteBuf);
            }
            if (afiCode == AddressFamilyIdentifierEnum.DISTINGUISHED_NAME.getIanaCode()) {
                return new LispDistinguishedNameAddress.DistinguishedNameAddressReader().readFrom(byteBuf);
            }
            if (afiCode == AddressFamilyIdentifierEnum.MAC.getIanaCode()) {
                return new LispMacAddress.MacAddressReader().readFrom(byteBuf);
            }
            if (afiCode == AddressFamilyIdentifierEnum.LCAF.getIanaCode()) {
                return new LispLcafAddress.LcafAddressReader().readFrom(byteBuf);
            }
            if (afiCode == AddressFamilyIdentifierEnum.AS.getIanaCode()) {
                return new LispAsAddress.AsAddressReader().readFrom(byteBuf);
            }
            return null;
        }
    }
}

