/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispTeRecord;

public final class LispTeLcafAddress
extends LispLcafAddress {
    private final List<LispTeRecord> records;

    private LispTeLcafAddress(List<LispTeRecord> records) {
        super(LispCanonicalAddressFormatEnum.TRAFFIC_ENGINEERING);
        this.records = records;
    }

    public List<LispTeRecord> getTeRecords() {
        return ImmutableList.copyOf(this.records);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.records);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispTeLcafAddress) {
            LispTeLcafAddress other = (LispTeLcafAddress)obj;
            return Objects.equals(this.records, other.records);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("TE records", this.records).toString();
    }

    public static class TeLcafAddressWriter
    implements LispAddressWriter<LispTeLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispTeLcafAddress address) throws LispWriterException {
            int lcafIndex = byteBuf.writerIndex();
            LispLcafAddress.serializeCommon(byteBuf, address);
            LispTeRecord.TeRecordWriter writer = new LispTeRecord.TeRecordWriter();
            List<LispTeRecord> teRecords = address.getTeRecords();
            for (LispTeRecord teRecord : teRecords) {
                writer.writeTo(byteBuf, teRecord);
            }
            LispLcafAddress.updateLength(lcafIndex, byteBuf);
        }
    }

    public static class TeLcafAddressReader
    implements LispAddressReader<LispTeLcafAddress> {
        @Override
        public LispTeLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            LispLcafAddress lcafAddress = LispLcafAddress.deserializeCommon(byteBuf);
            ArrayList teRecords = Lists.newArrayList();
            while (byteBuf.readerIndex() - 8 < lcafAddress.getLength()) {
                teRecords.add(new LispTeRecord.TeRecordReader().readFrom(byteBuf));
            }
            return new TeAddressBuilder().withTeRecords(teRecords).build();
        }
    }

    public static final class TeAddressBuilder
    extends LispLcafAddress.LcafAddressBuilder<TeAddressBuilder> {
        private List<LispTeRecord> records;

        public TeAddressBuilder withTeRecords(List<LispTeRecord> records) {
            this.records = records;
            return this;
        }

        @Override
        public LispTeLcafAddress build() {
            return new LispTeLcafAddress(this.records);
        }
    }
}

