/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.protocols;

import io.netty.buffer.ByteBuf;
import org.onlab.util.ByteOperator;
import org.onosproject.lisp.msg.protocols.DefaultLispEncapsulatedControl;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoReply;
import org.onosproject.lisp.msg.protocols.DefaultLispInfoRequest;
import org.onosproject.lisp.msg.protocols.DefaultLispMapNotify;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRegister;
import org.onosproject.lisp.msg.protocols.DefaultLispMapReply;
import org.onosproject.lisp.msg.protocols.DefaultLispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMapRequest;
import org.onosproject.lisp.msg.protocols.LispMessageReader;
import org.onosproject.lisp.msg.protocols.LispType;

public final class LispMessageReaderFactory {
    private static final int TYPE_SHIFT_BIT = 4;
    private static final int INFO_REPLY_INDEX = 3;

    private LispMessageReaderFactory() {
    }

    public static LispMessageReader getReader(ByteBuf buffer) {
        LispMessageReader<LispMapRequest> reader;
        LispType type = LispType.valueOf((short)(buffer.getUnsignedByte(0) >> 4));
        switch (type) {
            case LISP_MAP_REQUEST: {
                reader = new DefaultLispMapRequest.RequestReader();
                break;
            }
            case LISP_MAP_REPLY: {
                reader = new DefaultLispMapReply.ReplyReader();
                break;
            }
            case LISP_MAP_REGISTER: {
                reader = new DefaultLispMapRegister.RegisterReader();
                break;
            }
            case LISP_MAP_NOTIFY: {
                reader = new DefaultLispMapNotify.NotifyReader();
                break;
            }
            case LISP_INFO: {
                boolean isInfoReply = ByteOperator.getBit((byte)((byte)buffer.getUnsignedByte(0)), (int)3);
                if (isInfoReply) {
                    reader = new DefaultLispInfoReply.InfoReplyReader();
                    break;
                }
                reader = new DefaultLispInfoRequest.InfoRequestReader();
                break;
            }
            case LISP_ENCAPSULATED_CONTROL: {
                reader = new DefaultLispEncapsulatedControl.EcmReader();
                break;
            }
            case UNKNOWN: {
                throw new IllegalArgumentException("Unknown message type: " + type);
            }
            default: {
                throw new IllegalArgumentException("Undefined message type: " + type);
            }
        }
        return reader;
    }
}

