/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.lisp.msg.types.lcaf;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import org.onosproject.lisp.msg.exceptions.LispParseError;
import org.onosproject.lisp.msg.exceptions.LispReaderException;
import org.onosproject.lisp.msg.exceptions.LispWriterException;
import org.onosproject.lisp.msg.types.AddressFamilyIdentifierEnum;
import org.onosproject.lisp.msg.types.LispAddressReader;
import org.onosproject.lisp.msg.types.LispAddressWriter;
import org.onosproject.lisp.msg.types.LispAfiAddress;
import org.onosproject.lisp.msg.types.lcaf.LispAppDataLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispCanonicalAddressFormatEnum;
import org.onosproject.lisp.msg.types.lcaf.LispGeoCoordinateLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispListLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispMulticastLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNatLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispNonceLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispSegmentLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispSourceDestLcafAddress;
import org.onosproject.lisp.msg.types.lcaf.LispTeLcafAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LispLcafAddress
extends LispAfiAddress {
    private static final Logger log = LoggerFactory.getLogger(LispLcafAddress.class);
    private final LispCanonicalAddressFormatEnum lcafType;
    private final byte reserved1;
    private final byte reserved2;
    private final byte flag;
    private final short length;
    private static final int LCAF_AFI_CODE_BYTE_LENGTH = 2;
    private static final int LENGTH_FIELD_INDEX = 7;
    public static final int COMMON_HEADER_SIZE = 8;

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType, byte reserved1, byte reserved2, byte flag, short length) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved1 = reserved1;
        this.reserved2 = reserved2;
        this.flag = flag;
        this.length = length;
    }

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType, byte reserved2, byte flag, short length) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved2 = reserved2;
        this.flag = flag;
        this.length = length;
        this.reserved1 = 0;
    }

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType, byte reserved2, short length) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved2 = reserved2;
        this.length = length;
        this.reserved1 = 0;
        this.flag = 0;
    }

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType, byte reserved2) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved2 = reserved2;
        this.reserved1 = 0;
        this.flag = 0;
        this.length = 0;
    }

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType, short length) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved1 = 0;
        this.reserved2 = 0;
        this.flag = 0;
        this.length = length;
    }

    protected LispLcafAddress(LispCanonicalAddressFormatEnum lcafType) {
        super(AddressFamilyIdentifierEnum.LCAF);
        this.lcafType = lcafType;
        this.reserved1 = 0;
        this.reserved2 = 0;
        this.flag = 0;
        this.length = 0;
    }

    public LispCanonicalAddressFormatEnum getType() {
        return this.lcafType;
    }

    public byte getReserved1() {
        return this.reserved1;
    }

    public byte getReserved2() {
        return this.reserved2;
    }

    public byte getFlag() {
        return this.flag;
    }

    public short getLength() {
        return this.length;
    }

    public static LispLcafAddress deserializeCommon(ByteBuf byteBuf) {
        byteBuf.skipBytes(2);
        byte reserved1 = (byte)byteBuf.readUnsignedByte();
        byte flag = (byte)byteBuf.readUnsignedByte();
        byte lcafType = (byte)byteBuf.readUnsignedByte();
        byte reserved2 = (byte)byteBuf.readUnsignedByte();
        short length = (short)byteBuf.readUnsignedShort();
        return new LispLcafAddress(LispCanonicalAddressFormatEnum.valueOf(lcafType), reserved1, reserved2, flag, length);
    }

    public static void updateLength(int lcafIndex, ByteBuf byteBuf) {
        byteBuf.setByte(lcafIndex + 7, byteBuf.writerIndex() - 8 - lcafIndex);
    }

    public static void serializeCommon(ByteBuf byteBuf, LispLcafAddress address) {
        byteBuf.writeShort((int)AddressFamilyIdentifierEnum.LCAF.getIanaCode());
        byteBuf.writeByte((int)address.getReserved1());
        byteBuf.writeByte((int)address.getFlag());
        byteBuf.writeByte((int)address.getType().getLispCode());
        byteBuf.writeByte((int)address.getReserved2());
        byteBuf.writeShort((int)address.getLength());
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.lcafType, this.reserved1, this.reserved2, this.flag, this.length});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LispLcafAddress) {
            LispLcafAddress other = (LispLcafAddress)obj;
            return Objects.equals((Object)this.lcafType, (Object)other.lcafType) && Objects.equals(this.reserved1, other.reserved1) && Objects.equals(this.reserved2, other.reserved2) && Objects.equals(this.flag, other.flag) && Objects.equals(this.length, other.length);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("lcafType", (Object)this.lcafType).add("reserved1", (int)this.reserved1).add("reserved2", (int)this.reserved2).add("flag", (int)this.flag).add("length", (int)this.length).toString();
    }

    public static class LcafAddressWriter
    implements LispAddressWriter<LispLcafAddress> {
        @Override
        public void writeTo(ByteBuf byteBuf, LispLcafAddress address) throws LispWriterException {
            switch (address.getType()) {
                case APPLICATION_DATA: {
                    new LispAppDataLcafAddress.AppDataLcafAddressWriter().writeTo(byteBuf, (LispAppDataLcafAddress)address);
                    break;
                }
                case NAT: {
                    new LispNatLcafAddress.NatLcafAddressWriter().writeTo(byteBuf, (LispNatLcafAddress)address);
                    break;
                }
                case LIST: {
                    new LispListLcafAddress.ListLcafAddressWriter().writeTo(byteBuf, (LispListLcafAddress)address);
                    break;
                }
                case SEGMENT: {
                    new LispSegmentLcafAddress.SegmentLcafAddressWriter().writeTo(byteBuf, (LispSegmentLcafAddress)address);
                    break;
                }
                case GEO_COORDINATE: {
                    new LispGeoCoordinateLcafAddress.GeoCoordinateLcafAddressWriter().writeTo(byteBuf, (LispGeoCoordinateLcafAddress)address);
                    break;
                }
                case NONCE: {
                    new LispNonceLcafAddress.NonceLcafAddressWriter().writeTo(byteBuf, (LispNonceLcafAddress)address);
                    break;
                }
                case MULTICAST: {
                    new LispMulticastLcafAddress.MulticastLcafAddressWriter().writeTo(byteBuf, (LispMulticastLcafAddress)address);
                    break;
                }
                case SOURCE_DEST: {
                    new LispSourceDestLcafAddress.SourceDestLcafAddressWriter().writeTo(byteBuf, (LispSourceDestLcafAddress)address);
                    break;
                }
                case TRAFFIC_ENGINEERING: {
                    new LispTeLcafAddress.TeLcafAddressWriter().writeTo(byteBuf, (LispTeLcafAddress)address);
                    break;
                }
                default: {
                    log.warn("Unsupported LCAF type, please specify a correct LCAF type");
                }
            }
        }
    }

    public static class LcafAddressReader
    implements LispAddressReader<LispLcafAddress> {
        private static final int LCAF_TYPE_FIELD_INDEX = 4;

        @Override
        public LispLcafAddress readFrom(ByteBuf byteBuf) throws LispParseError, LispReaderException {
            int index = byteBuf.readerIndex();
            byte lcafType = (byte)byteBuf.getUnsignedByte(index + 4);
            if (lcafType == LispCanonicalAddressFormatEnum.APPLICATION_DATA.getLispCode()) {
                return new LispAppDataLcafAddress.AppDataLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.NAT.getLispCode()) {
                return new LispNatLcafAddress.NatLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.LIST.getLispCode()) {
                return new LispListLcafAddress.ListLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.SEGMENT.getLispCode()) {
                return new LispSegmentLcafAddress.SegmentLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.GEO_COORDINATE.getLispCode()) {
                return new LispGeoCoordinateLcafAddress.GeoCoordinateLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.NONCE.getLispCode()) {
                return new LispNonceLcafAddress.NonceLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.MULTICAST.getLispCode()) {
                return new LispMulticastLcafAddress.MulticastLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.SOURCE_DEST.getLispCode()) {
                return new LispSourceDestLcafAddress.SourceDestLcafAddressReader().readFrom(byteBuf);
            }
            if (lcafType == LispCanonicalAddressFormatEnum.TRAFFIC_ENGINEERING.getLispCode()) {
                return new LispTeLcafAddress.TeLcafAddressReader().readFrom(byteBuf);
            }
            log.warn("Unsupported LCAF type, please specify a correct LCAF type");
            return null;
        }
    }

    protected static class LcafAddressBuilder<T> {
        protected byte reserved1;
        protected byte flag;
        protected byte lcafType;
        protected byte reserved2;
        protected short length;

        protected LcafAddressBuilder() {
        }

        public T withReserved1(byte reserved1) {
            this.reserved1 = reserved1;
            return (T)this;
        }

        public T withFlag(byte flag) {
            this.flag = flag;
            return (T)this;
        }

        public T withLcafType(byte lcafType) {
            this.lcafType = lcafType;
            return (T)this;
        }

        public T withReserved2(byte reserved2) {
            this.reserved2 = reserved2;
            return (T)this;
        }

        public T withLength(short length) {
            this.length = length;
            return (T)this;
        }

        public LispLcafAddress build() {
            return new LispLcafAddress(LispCanonicalAddressFormatEnum.valueOf(this.lcafType), this.reserved1, this.reserved2, this.flag, this.length);
        }
    }
}

