/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller;

import java.nio.BufferUnderflowException;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.onlab.packet.DeserializationException;
import org.onlab.packet.Ethernet;
import org.onosproject.openflow.controller.Dpid;
import org.onosproject.openflow.controller.OpenFlowPacketContext;
import org.onosproject.openflow.controller.OpenFlowSwitch;
import org.onosproject.security.AppGuard;
import org.onosproject.security.AppPermission;
import org.projectfloodlight.openflow.protocol.OFMessage;
import org.projectfloodlight.openflow.protocol.OFPacketIn;
import org.projectfloodlight.openflow.protocol.OFPacketOut;
import org.projectfloodlight.openflow.protocol.OFVersion;
import org.projectfloodlight.openflow.protocol.action.OFActionOutput;
import org.projectfloodlight.openflow.protocol.match.MatchField;
import org.projectfloodlight.openflow.types.OFBufferId;
import org.projectfloodlight.openflow.types.OFPort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultOpenFlowPacketContext
implements OpenFlowPacketContext {
    private final AtomicBoolean free = new AtomicBoolean(true);
    private final AtomicBoolean isBuilt = new AtomicBoolean(false);
    private final OpenFlowSwitch sw;
    private final OFPacketIn pktin;
    private OFPacketOut pktout = null;
    private final boolean isBuffered;

    private DefaultOpenFlowPacketContext(OpenFlowSwitch s, OFPacketIn pkt) {
        this.sw = s;
        this.pktin = pkt;
        this.isBuffered = this.pktin.getBufferId() != OFBufferId.NO_BUFFER;
    }

    @Override
    public void send() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        if (this.block() && this.isBuilt.get()) {
            this.sw.sendMsg((OFMessage)this.pktout);
        }
    }

    @Override
    public void build(OFPort outPort) {
        if (this.isBuilt.getAndSet(true)) {
            return;
        }
        OFPacketOut.Builder builder = this.sw.factory().buildPacketOut();
        OFActionOutput act = this.buildOutput(outPort.getPortNumber());
        this.pktout = builder.setXid(this.pktin.getXid()).setInPort(this.pktinInPort()).setBufferId(OFBufferId.NO_BUFFER).setData(this.pktin.getData()).setActions(Collections.singletonList(act)).build();
    }

    @Override
    public void build(Ethernet ethFrame, OFPort outPort) {
        if (this.isBuilt.getAndSet(true)) {
            return;
        }
        OFPacketOut.Builder builder = this.sw.factory().buildPacketOut();
        OFActionOutput act = this.buildOutput(outPort.getPortNumber());
        this.pktout = builder.setXid(this.pktin.getXid()).setBufferId(OFBufferId.NO_BUFFER).setInPort(this.pktinInPort()).setActions(Collections.singletonList(act)).setData(ethFrame.serialize()).build();
    }

    @Override
    public Ethernet parsed() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        try {
            return (Ethernet)Ethernet.deserializer().deserialize(this.pktin.getData(), 0, this.pktin.getData().length);
        }
        catch (NullPointerException | BufferUnderflowException | DeserializationException e) {
            Logger log = LoggerFactory.getLogger(this.getClass());
            log.error("packet deserialization problem : {}", (Object)e.getMessage());
            return null;
        }
    }

    @Override
    public Dpid dpid() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return this.sw.getDpid();
    }

    public static OpenFlowPacketContext packetContextFromPacketIn(OpenFlowSwitch s, OFPacketIn pkt) {
        return new DefaultOpenFlowPacketContext(s, pkt);
    }

    @Override
    public Integer inPort() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return this.pktinInPort().getPortNumber();
    }

    private OFPort pktinInPort() {
        if (this.pktin.getVersion() == OFVersion.OF_10) {
            return this.pktin.getInPort();
        }
        return (OFPort)this.pktin.getMatch().get(MatchField.IN_PORT);
    }

    @Override
    public byte[] unparsed() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return (byte[])this.pktin.getData().clone();
    }

    private OFActionOutput buildOutput(Integer port) {
        OFActionOutput act = this.sw.factory().actions().buildOutput().setPort(OFPort.of((int)port)).build();
        return act;
    }

    @Override
    public boolean block() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_WRITE);
        return this.free.getAndSet(false);
    }

    @Override
    public boolean isHandled() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return !this.free.get();
    }

    @Override
    public boolean isBuffered() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        return this.isBuffered;
    }

    @Override
    public Optional<Long> cookie() {
        AppGuard.checkPermission((AppPermission.Type)AppPermission.Type.PACKET_READ);
        if (this.pktin.getVersion() != OFVersion.OF_10) {
            return Optional.of(this.pktin.getCookie().getValue());
        }
        return Optional.empty();
    }
}

