/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.onlab.packet.EthType;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.Config;
import org.onosproject.openflow.controller.OpenFlowClassifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFlowClassifierConfig
extends Config<DeviceId> {
    private static Logger log = LoggerFactory.getLogger(OpenFlowClassifierConfig.class);
    public static final String TARGET_QUEUE = "target-queue";
    public static final String ETHER_TYPE = "ethernet-type";
    private static final String CONFIG_VALUE_ERROR = "Error parsing config value";
    private static final String CLASSF_NULL_ERROR = "Classifier cannot be null";

    private short etherValue(String etherType) throws IllegalArgumentException {
        short etherTypeValue;
        try {
            if (etherType.startsWith("0x")) {
                Integer e = Integer.valueOf(etherType.substring(2), 16);
                if (e < 0 || e > 65535) {
                    throw new IllegalArgumentException("EtherType value out of range");
                }
                etherTypeValue = e.shortValue();
            } else {
                etherTypeValue = EthType.EtherType.valueOf((String)etherType).ethType().toShort();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to parse ethernet type string");
        }
        return etherTypeValue;
    }

    public boolean isValid() {
        for (JsonNode node : this.array) {
            if (!this.hasOnlyFields((ObjectNode)node, new String[]{TARGET_QUEUE, ETHER_TYPE})) {
                return false;
            }
            ObjectNode obj = (ObjectNode)node;
            if (!this.isString(obj, ETHER_TYPE, Config.FieldPresence.MANDATORY, new String[0]) || !this.isIntegralNumber(obj, TARGET_QUEUE, Config.FieldPresence.MANDATORY, new long[]{0L, 7L})) {
                return false;
            }
            try {
                this.etherValue(node.path(ETHER_TYPE).asText());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public Set<OpenFlowClassifier> getClassifiers() {
        HashSet classifiers = Sets.newHashSet();
        for (JsonNode classfNode : this.array) {
            DeviceId deviceId = (DeviceId)this.subject();
            short ethernetType = this.etherValue(classfNode.path(ETHER_TYPE).asText());
            int idQueue = Integer.valueOf(classfNode.path(TARGET_QUEUE).asText());
            OpenFlowClassifier classf = new OpenFlowClassifier.Builder(deviceId, idQueue).ethernetType(ethernetType).build();
            classifiers.add(classf);
        }
        return classifiers;
    }

    public void addClassifier(OpenFlowClassifier classf) {
        Preconditions.checkNotNull((Object)classf, (Object)CLASSF_NULL_ERROR);
        Preconditions.checkArgument((boolean)classf.deviceId().equals(this.subject()));
        ObjectNode classfNode = this.array.addObject();
        EthType.EtherType e = EthType.EtherType.lookup((short)classf.ethernetType());
        if (e.equals((Object)EthType.EtherType.UNKNOWN)) {
            classfNode.put(ETHER_TYPE, String.format("0x%04x", classf.ethernetType()));
        } else {
            classfNode.put(ETHER_TYPE, e.name());
        }
        classfNode.put(TARGET_QUEUE, classf.idQueue());
    }

    public void removeClassifier(OpenFlowClassifier classf) {
        Preconditions.checkNotNull((Object)classf, (Object)CLASSF_NULL_ERROR);
        Preconditions.checkArgument((boolean)classf.deviceId().equals(this.subject()));
        Iterator it = this.array.iterator();
        while (it.hasNext()) {
            JsonNode node = (JsonNode)it.next();
            if (this.etherValue(node.path(ETHER_TYPE).asText()) != classf.ethernetType() || Integer.valueOf(node.path(TARGET_QUEUE).asText()).intValue() != classf.idQueue()) continue;
            it.remove();
            break;
        }
    }
}

