/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import org.onlab.util.Tools;
import org.projectfloodlight.openflow.util.HexString;

public final class Dpid {
    private static final String SCHEME = "of";
    private static final long UNKNOWN = 0L;
    private final long value;

    public Dpid() {
        this.value = 0L;
    }

    public Dpid(long value) {
        this.value = value;
    }

    public Dpid(String value) {
        this.value = HexString.toLong((String)value);
    }

    public long value() {
        return this.value;
    }

    public String toString() {
        return HexString.toHexString((long)this.value);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Dpid)) {
            return false;
        }
        Dpid otherDpid = (Dpid)other;
        return this.value == otherDpid.value;
    }

    public int hashCode() {
        return Long.hashCode(this.value);
    }

    public static Dpid dpid(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new Dpid(Tools.fromHex((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(Dpid dpid) {
        return Dpid.uri(dpid.value);
    }

    public static URI uri(long value) {
        try {
            return new URI("of:" + Tools.toHex((long)value));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

