/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.openflow.controller;

import java.util.Objects;
import org.onosproject.net.DeviceId;

public final class OpenFlowClassifier {
    private final short ethernetType;
    private final int idQueue;
    private final DeviceId deviceId;

    private OpenFlowClassifier(Builder builder) {
        this.idQueue = builder.idQueue;
        this.ethernetType = builder.ethernetType;
        this.deviceId = builder.deviceId;
    }

    public short ethernetType() {
        return this.ethernetType;
    }

    public DeviceId deviceId() {
        return this.deviceId;
    }

    public int idQueue() {
        return this.idQueue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OpenFlowClassifier)) {
            return false;
        }
        OpenFlowClassifier classifier = (OpenFlowClassifier)o;
        return this.ethernetType == classifier.ethernetType() && this.idQueue == classifier.idQueue() && this.deviceId.equals((Object)classifier.deviceId());
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.idQueue, this.ethernetType);
    }

    public static class Builder {
        private Short ethernetType = 0;
        private int idQueue;
        private DeviceId deviceId;

        public Builder(DeviceId deviceId, int idQueue) {
            this.deviceId = deviceId;
            this.idQueue = idQueue;
        }

        public Builder ethernetType(short ethernetType) {
            this.ethernetType = ethernetType;
            return this;
        }

        public OpenFlowClassifier build() {
            return new OpenFlowClassifier(this);
        }
    }
}

