/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ospf.controller;

import com.google.common.base.Preconditions;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import org.onlab.packet.IpAddress;

public class OspfRouterId {
    private static final String SCHEME = "l3";
    private static final long UNKNOWN = 0L;
    private final IpAddress ipAddress;

    public OspfRouterId(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public static OspfRouterId ospfRouterId(IpAddress ipAddress) {
        return new OspfRouterId(ipAddress);
    }

    public static OspfRouterId ospfRouterId(URI uri) {
        Preconditions.checkArgument((boolean)uri.getScheme().equals(SCHEME), (Object)"Unsupported URI scheme");
        return new OspfRouterId(IpAddress.valueOf((String)uri.getSchemeSpecificPart()));
    }

    public static URI uri(OspfRouterId ospfRouterId) {
        return OspfRouterId.uri(ospfRouterId.ipAddress());
    }

    public static URI uri(IpAddress ipAddress) {
        try {
            return new URI(SCHEME, ipAddress.toString(), null);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public String toString() {
        return this.ipAddress.toString();
    }

    public boolean equals(Object other) {
        if (!(other instanceof OspfRouterId)) {
            return false;
        }
        OspfRouterId otherOspfRouterId = (OspfRouterId)other;
        return Objects.equals(this.ipAddress, otherOspfRouterId.ipAddress);
    }

    public int hashCode() {
        return Objects.hash(this.ipAddress);
    }
}

