/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.behaviour.PatchDescription;
import org.onosproject.net.behaviour.TunnelDescription;
import org.onosproject.net.behaviour.TunnelEndPoint;
import org.onosproject.net.behaviour.TunnelKey;

public final class OvsdbInterface {
    private final String name;
    private final Type type;
    private final Optional<Long> mtu;
    private final Map<String, String> options;

    private OvsdbInterface(String name, Type type, Optional<Long> mtu, Map<String, String> options) {
        this.name = name;
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"the type of interface can not be null"));
        this.mtu = mtu;
        this.options = Maps.newHashMap(options);
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public String typeToString() {
        return this.type.name().toLowerCase();
    }

    public Optional<Long> mtu() {
        return this.mtu;
    }

    public Map<String, String> options() {
        return this.options;
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbInterface) {
            OvsdbInterface otherOvsdbInterface = (OvsdbInterface)obj;
            return Objects.equals(this.name, otherOvsdbInterface.name);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("type", (Object)this.type).add("mtu", this.mtu).add("options", this.options).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(TunnelDescription tunnelDesc) {
        return new Builder(tunnelDesc);
    }

    public static Builder builder(PatchDescription patchDesc) {
        return new Builder(patchDesc);
    }

    public static final class Builder {
        private String name;
        private Type type;
        private Optional<Long> mtu = Optional.empty();
        private Map<String, String> options = Maps.newHashMap();

        private Builder() {
        }

        private Builder(TunnelDescription tunnelDesc) {
            this.name = tunnelDesc.ifaceName();
            this.type = Type.valueOf(tunnelDesc.type().name());
            HashMap tunOptions = Maps.newHashMap();
            if (tunnelDesc.local().isPresent()) {
                tunOptions.put("local_ip", ((TunnelEndPoint)tunnelDesc.local().get()).strValue());
            }
            if (tunnelDesc.remote().isPresent()) {
                tunOptions.put("remote_ip", ((TunnelEndPoint)tunnelDesc.remote().get()).strValue());
            }
            if (tunnelDesc.key().isPresent()) {
                tunOptions.put("key", ((TunnelKey)tunnelDesc.key().get()).strValue());
            }
            tunOptions.putAll(((DefaultAnnotations)tunnelDesc.annotations()).asMap());
            this.options = tunOptions;
        }

        private Builder(PatchDescription patchDesc) {
            this.name = patchDesc.ifaceName();
            this.type = Type.PATCH;
            HashMap patchOptions = Maps.newHashMap();
            patchOptions.put("peer", patchDesc.peer());
            this.options = patchOptions;
        }

        public OvsdbInterface build() {
            return new OvsdbInterface(this.name, this.type, this.mtu, this.options);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            return this;
        }

        public Builder mtu(Long mtu) {
            this.mtu = Optional.ofNullable(mtu);
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = Maps.newHashMap(options);
            return this;
        }
    }

    public static enum Type {
        SYSTEM,
        INTERNAL,
        TAP,
        GRE,
        VXLAN,
        PATCH,
        DPDK;

    }
}

