/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.onlab.util.Bandwidth;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.behaviour.QosDescription;

public final class OvsdbQos {
    private final String type;
    private Optional<Map<Long, String>> queues;
    private Map<String, String> otherConfigs;
    private Map<String, String> externalIds;

    private OvsdbQos(String type, Optional<Map<Long, String>> queues, Map<String, String> otherConfigs, Map<String, String> externalIds) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.queues = queues;
        this.otherConfigs = otherConfigs;
        this.externalIds = externalIds;
    }

    public String qosType() {
        return this.type;
    }

    public Optional<Map<Long, String>> qosQueues() {
        return this.queues;
    }

    public Map<String, String> otherConfigs() {
        return this.otherConfigs;
    }

    public Map<String, String> externalIds() {
        return this.externalIds;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.queues, this.externalIds);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof OvsdbQos) {
            OvsdbQos other = (OvsdbQos)obj;
            return Objects.equals(this.type, other.type) && Objects.equals(this.otherConfigs, other.otherConfigs) && Objects.equals(this.queues, other.queues) && Objects.equals(this.externalIds, other.externalIds);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("qosType", (Object)this.qosType()).add("qosQueues", this.qosQueues()).add("otherConfigs", this.otherConfigs()).add("externalIds", this.externalIds()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(QosDescription qosDesc) {
        return new Builder(qosDesc);
    }

    public static final class Builder {
        private String type;
        private Optional<Map<Long, String>> queues = Optional.empty();
        private Map<String, String> otherConfigs = Maps.newHashMap();
        private Map<String, String> externalIds = Maps.newHashMap();

        private Builder() {
        }

        private Builder(QosDescription qosDesc) {
            if (qosDesc.maxRate().isPresent()) {
                this.otherConfigs.put("max-rate", String.valueOf((long)((Bandwidth)qosDesc.maxRate().get()).bps()));
            }
            if (qosDesc.cir().isPresent()) {
                this.otherConfigs.put("cir", ((Long)qosDesc.cir().get()).toString());
            }
            if (qosDesc.cbs().isPresent()) {
                this.otherConfigs.put("cbs", ((Long)qosDesc.cbs().get()).toString());
            }
            if (qosDesc.queues().isPresent()) {
                HashMap map = new HashMap();
                ((Map)qosDesc.queues().get()).forEach((k, v) -> map.put(k, v.queueId().name()));
                this.queues = Optional.ofNullable(map);
            }
            this.type = qosDesc.type() == QosDescription.Type.EGRESS_POLICER ? "egress-policer" : "linux-".concat(qosDesc.type().name().toLowerCase());
            this.externalIds.putAll(((DefaultAnnotations)qosDesc.annotations()).asMap());
            this.externalIds.put("onos-qos-id", qosDesc.qosId().name());
        }

        public OvsdbQos build() {
            return new OvsdbQos(this.type, this.queues, this.otherConfigs, this.externalIds);
        }

        public Builder qosType(String type) {
            this.type = type;
            return this;
        }

        public Builder queues(Map<Long, String> queues) {
            this.queues = Optional.ofNullable(queues);
            return this;
        }

        public Builder otherConfigs(Map<String, String> otherConfigs) {
            this.otherConfigs = Maps.newHashMap(otherConfigs);
            return this;
        }

        public Builder externalIds(Map<String, String> ids) {
            this.externalIds = ids;
            return this;
        }
    }
}

