/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Set;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onosproject.ovsdb.controller.OvsdbDatapathId;
import org.onosproject.ovsdb.controller.OvsdbEventSubject;
import org.onosproject.ovsdb.controller.OvsdbIfaceId;
import org.onosproject.ovsdb.controller.OvsdbPortName;
import org.onosproject.ovsdb.controller.OvsdbPortNumber;
import org.onosproject.ovsdb.controller.OvsdbPortType;

public class DefaultEventSubject
implements OvsdbEventSubject {
    private final MacAddress mac;
    private final Set<IpAddress> ips;
    private final OvsdbPortName portname;
    private final OvsdbPortNumber portnumber;
    private final OvsdbDatapathId dpid;
    private final OvsdbPortType portType;
    private final OvsdbIfaceId ifaceid;

    public DefaultEventSubject(MacAddress mac, Set<IpAddress> ips, OvsdbPortName portname, OvsdbPortNumber portnumber, OvsdbDatapathId dpid, OvsdbPortType portType, OvsdbIfaceId ifaceid) {
        this.mac = mac;
        this.ips = ips;
        this.portname = portname;
        this.portnumber = portnumber;
        this.dpid = dpid;
        this.portType = portType;
        this.ifaceid = ifaceid;
    }

    @Override
    public MacAddress hwAddress() {
        return this.mac;
    }

    @Override
    public Set<IpAddress> ipAddress() {
        return this.ips;
    }

    @Override
    public OvsdbPortName portName() {
        return this.portname;
    }

    @Override
    public OvsdbPortNumber portNumber() {
        return this.portnumber;
    }

    @Override
    public OvsdbPortType portType() {
        return this.portType;
    }

    @Override
    public OvsdbDatapathId dpid() {
        return this.dpid;
    }

    @Override
    public OvsdbIfaceId ifaceid() {
        return this.ifaceid;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mac, this.portname, this.portnumber, this.dpid, this.portType, this.ifaceid});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultEventSubject) {
            DefaultEventSubject other = (DefaultEventSubject)obj;
            return Objects.equals(this.mac, other.mac) && Objects.equals(this.portname, other.portname) && Objects.equals(this.portnumber, other.portnumber) && Objects.equals((Object)this.dpid, (Object)other.dpid) && Objects.equals(this.portType, other.portType) && Objects.equals((Object)this.ifaceid, (Object)other.ifaceid);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mac", (Object)this.mac).add("portname", (Object)this.portname).add("portnumber", (Object)this.portnumber).add("portType", (Object)this.portType).add("ipAddresses", this.ips).add("dpid", (Object)this.dpid).add("ifaceid", (Object)this.ifaceid).toString();
    }
}

