/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ovsdb.controller;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.behaviour.ControllerInfo;
import org.onosproject.net.behaviour.DeviceCpuStats;
import org.onosproject.net.behaviour.DeviceMemoryStats;
import org.onosproject.net.behaviour.MirroringName;
import org.onosproject.net.behaviour.MirroringStatistics;
import org.onosproject.net.behaviour.QosId;
import org.onosproject.net.behaviour.QueueDescription;
import org.onosproject.net.behaviour.QueueId;
import org.onosproject.ovsdb.controller.OvsdbBridge;
import org.onosproject.ovsdb.controller.OvsdbInterface;
import org.onosproject.ovsdb.controller.OvsdbMirror;
import org.onosproject.ovsdb.controller.OvsdbNodeId;
import org.onosproject.ovsdb.controller.OvsdbPort;
import org.onosproject.ovsdb.controller.OvsdbPortName;
import org.onosproject.ovsdb.controller.OvsdbQos;
import org.onosproject.ovsdb.controller.OvsdbQueue;
import org.onosproject.ovsdb.rfc.jsonrpc.OvsdbRpc;
import org.onosproject.ovsdb.rfc.message.TableUpdates;
import org.onosproject.ovsdb.rfc.notation.Row;
import org.onosproject.ovsdb.rfc.schema.DatabaseSchema;
import org.onosproject.ovsdb.rfc.table.Interface;
import org.onosproject.ovsdb.rfc.table.OvsdbTable;

public interface OvsdbClientService
extends OvsdbRpc {
    public OvsdbNodeId nodeId();

    public boolean createMirror(String var1, OvsdbMirror var2);

    public String getMirrorUuid(String var1);

    public Set<MirroringStatistics> getMirroringStatistics(DeviceId var1);

    public void dropMirror(MirroringName var1);

    public void applyQos(PortNumber var1, String var2);

    public void removeQos(PortNumber var1);

    public boolean createQos(OvsdbQos var1);

    public void dropQos(QosId var1);

    public OvsdbQos getQos(QosId var1);

    public Set<OvsdbQos> getQoses();

    public void bindQueues(QosId var1, Map<Long, QueueDescription> var2);

    public void unbindQueues(QosId var1, List<Long> var2);

    public boolean createQueue(OvsdbQueue var1);

    public void dropQueue(QueueId var1);

    public OvsdbQueue getQueue(QueueId var1);

    public Set<OvsdbQueue> getQueues();

    public boolean createInterface(String var1, OvsdbInterface var2);

    public boolean dropInterface(String var1);

    public boolean createBridge(OvsdbBridge var1);

    public void dropBridge(String var1);

    public Set<OvsdbBridge> getBridges();

    public Set<ControllerInfo> getControllers(DeviceId var1);

    public ControllerInfo localController();

    public void setControllersWithDeviceId(DeviceId var1, List<ControllerInfo> var2);

    public void createPort(String var1, String var2);

    public void dropPort(String var1, String var2);

    public Set<OvsdbPort> getPorts();

    public Set<Interface> getInterfaces();

    public Interface getInterface(String var1);

    public boolean isConnected();

    public String getBridgeUuid(String var1);

    public String getPortUuid(String var1, String var2);

    public ListenableFuture<DatabaseSchema> getOvsdbSchema(String var1);

    public ListenableFuture<TableUpdates> monitorTables(String var1, String var2);

    public DatabaseSchema getDatabaseSchema(String var1);

    public Row getRow(String var1, String var2, String var3);

    public void removeRow(String var1, String var2, String var3);

    public void updateOvsdbStore(String var1, String var2, String var3, Row var4);

    public Set<OvsdbPort> getLocalPorts(Iterable<String> var1);

    public void disconnect();

    public List<OvsdbPortName> getPorts(List<String> var1, DeviceId var2);

    public boolean getPortError(List<OvsdbPortName> var1, DeviceId var2);

    public Optional<Object> getFirstRow(String var1, OvsdbTable var2);

    public Optional<DeviceCpuStats> getDeviceCpuUsage();

    public Optional<DeviceMemoryStats> getDeviceMemoryUsage();
}

